/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.item;

import com.oblivioussp.spartanweaponry.capability.QuiverCapabilityProvider;
import com.oblivioussp.spartanweaponry.capability.QuiverCurioCapabilityProvider;
import com.oblivioussp.spartanweaponry.client.ClientHelper;
import com.oblivioussp.spartanweaponry.client.model.QuiverModelBase;
import com.oblivioussp.spartanweaponry.init.ModItems;
import java.util.List;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public abstract class QuiverBaseItem
extends Item {
    public static final String NBT_SIZE = "size";
    public static final String NBT_CURRENT_AMMO = "currentAmmo";
    public static final String NBT_TOTAL_AMMO = "totalAmmo";
    public static final String NBT_AMMO_COLLECT = "ammoCollect";
    public static final String NBT_CLIENT_INVENTORY = "ClientInventory";
    public static final String NBT_OFFHAND_MOVED = "OffhandMoved";
    public static final String NBT_ITEM_ID = "Id";
    public static final String NBT_ITEM_SLOT = "Slot";
    public static final NonNullSupplier<IllegalArgumentException> CAPABILITY_EXCEPTION = () -> new IllegalArgumentException("Capability must not be null!");
    protected int ammoSlots = 4;

    public QuiverBaseItem(String regName, int inventorySize) {
        super(new Item.Properties().func_200916_a(ModItems.GROUP_SW).func_200917_a(1));
        this.setRegistryName("spartanweaponry", regName);
        if (FMLEnvironment.dist.isClient()) {
            ClientHelper.registerQuiverPropertyOverrides(this);
        }
        this.ammoSlots = inventorySize;
    }

    public int getAmmoCount(ItemStack stack) {
        int ammo = 0;
        ListNBT list = null;
        list = stack.func_196082_o().func_150295_c(NBT_CLIENT_INVENTORY, 10);
        if (list == null) {
            return 0;
        }
        for (int i = 0; i < list.size(); ++i) {
            ItemStack item = ItemStack.func_199557_a((CompoundNBT)list.func_150305_b(i));
            if (item.func_190926_b()) continue;
            ++ammo;
        }
        ammo = this.ammoSlots >= 9 ? MathHelper.func_76125_a((int)ammo, (int)0, (int)5) : MathHelper.func_76125_a((int)ammo, (int)0, (int)3);
        return ammo;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT nbt) {
        if (ModList.get().isLoaded("curios")) {
            return new QuiverCurioCapabilityProvider(stack, this.ammoSlots, nbt, this);
        }
        return new QuiverCapabilityProvider(stack, this.ammoSlots, nbt);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack heldItem = playerIn.func_184586_b(handIn);
        if (!worldIn.field_72995_K) {
            if (!playerIn.func_213453_ef()) {
                IItemHandler handler = (IItemHandler)heldItem.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElseThrow(CAPABILITY_EXCEPTION);
                if (handler instanceof ItemStackHandler) {
                    SlotType slotType = handIn == Hand.OFF_HAND ? SlotType.OFF_HAND : SlotType.MAIN_HAND;
                    this.openGui(heldItem, playerIn, slotType, -1);
                    return ActionResult.func_226249_b_((Object)heldItem);
                }
                return ActionResult.func_226251_d_((Object)heldItem);
            }
            boolean ammoCollect = !heldItem.func_196082_o().func_74767_n(NBT_AMMO_COLLECT);
            heldItem.func_77978_p().func_74757_a(NBT_AMMO_COLLECT, ammoCollect);
            String collectStatus = ammoCollect ? "enabled" : "disabled";
            TextFormatting collectColour = ammoCollect ? TextFormatting.GREEN : TextFormatting.RED;
            playerIn.func_146105_b((ITextComponent)new TranslationTextComponent("message.spartanweaponry.ammo_collect_toggle").func_230529_a_((ITextComponent)new TranslationTextComponent("tooltip.spartanweaponry." + collectStatus).func_240699_a_(collectColour)), true);
            return ActionResult.func_226251_d_((Object)heldItem);
        }
        return ActionResult.func_226250_c_((Object)heldItem);
    }

    public CompoundNBT getShareTag(ItemStack stack) {
        IItemHandler handler = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).orElseThrow(CAPABILITY_EXCEPTION);
        INBT capTag = CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.getStorage().writeNBT(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (Object)handler, null);
        CompoundNBT tag = super.getShareTag(stack);
        if (tag == null) {
            tag = new CompoundNBT();
        }
        if (capTag != null) {
            tag.func_218657_a(NBT_CLIENT_INVENTORY, capTag);
        }
        return tag;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        int itemCount = 0;
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.spartanweaponry.quiver_capacity").func_240699_a_(TextFormatting.DARK_AQUA).func_230529_a_((ITextComponent)new TranslationTextComponent("tooltip.spartanweaponry.quiver_capacity.value", new Object[]{this.ammoSlots}).func_240699_a_(TextFormatting.GRAY)));
        boolean ammoCollect = stack.func_196082_o().func_74767_n(NBT_AMMO_COLLECT);
        String collectStatus = ammoCollect ? "enabled" : "disabled";
        TextFormatting statusColour = ammoCollect ? TextFormatting.GREEN : TextFormatting.RED;
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.spartanweaponry.quiver_collect_status").func_230529_a_((ITextComponent)new TranslationTextComponent("tooltip.spartanweaponry." + collectStatus).func_240699_a_(statusColour)).func_240699_a_(TextFormatting.DARK_AQUA));
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.spartanweaponry.quiver_contains").func_240699_a_(TextFormatting.DARK_AQUA));
        ListNBT list = stack.func_196082_o().func_150295_c(NBT_CLIENT_INVENTORY, 10);
        for (int i = 0; i < list.size(); ++i) {
            ItemStack slotStack = ItemStack.func_199557_a((CompoundNBT)list.func_150305_b(i));
            if (slotStack.func_190926_b()) continue;
            if (itemCount < 2 || Screen.func_231173_s_()) {
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.spartanweaponry.quiver_ammo", new Object[]{TextFormatting.AQUA + "" + slotStack.func_190916_E(), TextFormatting.GRAY + slotStack.func_200301_q().getString()}).func_240699_a_(TextFormatting.GRAY));
            } else if (itemCount == 2) {
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.spartanweaponry.quiver_show_contents", new Object[]{TextFormatting.AQUA + "SHIFT" + TextFormatting.DARK_GRAY}).func_240699_a_(TextFormatting.DARK_GRAY));
            }
            ++itemCount;
        }
        if (itemCount == 0) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.spartanweaponry.quiver_none").func_240699_a_(TextFormatting.GRAY));
        }
        if (this.ammoSlots != 12) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.spartanweaponry.quiver_upgrade").func_240699_a_(TextFormatting.YELLOW));
        }
    }

    public abstract void openGui(ItemStack var1, PlayerEntity var2, SlotType var3, int var4);

    public abstract boolean isAmmoValid(ItemStack var1, ItemStack var2);

    @OnlyIn(value=Dist.CLIENT)
    public abstract QuiverModelBase getModel();

    @OnlyIn(value=Dist.CLIENT)
    public abstract ResourceLocation getModelTexture();

    public static enum SlotType {
        UNDEFINED,
        MAIN_HAND,
        OFF_HAND,
        HOTBAR,
        CURIO;

    }
}

