/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.loot;

import com.google.gson.JsonObject;
import com.oblivioussp.spartanweaponry.api.IWeaponTraitContainer;
import com.oblivioussp.spartanweaponry.api.WeaponTraits;
import com.oblivioussp.spartanweaponry.api.trait.WeaponTrait;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class DecapitateLootModifier
extends LootModifier {
    private final Item skull;

    public DecapitateLootModifier(ILootCondition[] conditionsIn, Item skullItem) {
        super(conditionsIn);
        this.skull = skullItem;
    }

    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        Entity killer = (Entity)context.func_216031_c(LootParameters.field_216284_d);
        if (killer instanceof LivingEntity) {
            IWeaponTraitContainer container;
            WeaponTrait trait;
            LivingEntity living = (LivingEntity)killer;
            ItemStack weapon = living.func_184614_ca();
            if (context.func_216032_b().nextDouble() < (double)(WeaponTraits.DECAPITATE.getMagnitude() / 100.0f) && weapon.func_77973_b() instanceof IWeaponTraitContainer && (trait = (container = (IWeaponTraitContainer)weapon.func_77973_b()).getFirstWeaponTraitWithType("decapitate")) != null) {
                ItemStack skullStack = new ItemStack((IItemProvider)this.skull);
                Entity thisEntity = (Entity)context.func_216031_c(LootParameters.field_216281_a);
                if (thisEntity instanceof PlayerEntity) {
                    PlayerEntity player = (PlayerEntity)thisEntity;
                    skullStack.func_77978_p().func_74778_a("SkullOwner", player.func_146103_bH().getName());
                }
                generatedLoot.add(skullStack);
            }
        }
        return generatedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<DecapitateLootModifier> {
        public DecapitateLootModifier read(ResourceLocation location, JsonObject object, ILootCondition[] lootConditions) {
            Item skullItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)object, (String)"skull")));
            return new DecapitateLootModifier(lootConditions, skullItem);
        }

        public JsonObject write(DecapitateLootModifier instance) {
            JsonObject result = this.makeConditions(instance.conditions);
            result.addProperty("skull", ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)instance.skull).toString());
            return result;
        }
    }
}

