/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.mixin;

import com.oblivioussp.spartanweaponry.api.WeaponTraits;
import com.oblivioussp.spartanweaponry.item.SwordBaseItem;
import com.oblivioussp.spartanweaponry.mixin.EntityMixin;
import com.oblivioussp.spartanweaponry.util.IArmorPiercingDamageSource;
import com.oblivioussp.spartanweaponry.util.Log;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.util.CombatRules;
import net.minecraft.util.DamageSource;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public class LivingEntityMixin
extends EntityMixin {
    @Inject(at={@At(value="HEAD")}, method={"canBlockDamageSource(Lnet/minecraft/util/DamageSource;)Z"}, cancellable=true)
    private void canBlockDamageSource(DamageSource source, CallbackInfoReturnable<Boolean> callback) {
        LivingEntity thisLiving;
        Entity thisEntity = this.field_70170_p.func_73045_a(this.func_145782_y());
        if (thisEntity instanceof LivingEntity && (thisLiving = (LivingEntity)thisEntity).func_184607_cu().func_77973_b() instanceof SwordBaseItem && ((SwordBaseItem)thisLiving.func_184607_cu().func_77973_b()).hasWeaponTrait(WeaponTraits.BLOCK_MELEE)) {
            callback.setReturnValue((Object)false);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"applyArmorCalculations(Lnet/minecraft/util/DamageSource;F)F"}, cancellable=true)
    protected void applyArmorCalculations(DamageSource source, float damage, CallbackInfoReturnable<Float> callback) {
        if (source instanceof IArmorPiercingDamageSource && !source.func_76363_c()) {
            this.func_230294_b_(source, damage);
            float percentage = ((IArmorPiercingDamageSource)source).getArmorPiercingPercentage();
            Log.debug("Found armor piercing damage source! Reducing armor value of target by " + percentage * 100.0f + "%");
            float toughness = (float)this.func_233637_b_(Attributes.field_233827_j_);
            float armorPiercingDamage = damage * percentage;
            float regularDamage = damage - armorPiercingDamage;
            float reducedDamage = CombatRules.func_189427_a((float)regularDamage, (float)this.func_70658_aO(), (float)toughness);
            float resultDamage = armorPiercingDamage + reducedDamage;
            Log.debug("Full damage: " + damage + " Armor value: " + (float)this.func_70658_aO() + " Damage ignoring armor (" + percentage * 100.0f + "% damage): " + armorPiercingDamage + " Damage not ignoring armor: " + regularDamage + " Reduced Damage: " + reducedDamage + " Result Damage: " + resultDamage);
            callback.setReturnValue((Object)Float.valueOf(resultDamage));
        }
    }

    @Shadow
    protected void func_230294_b_(DamageSource source, float damage) {
        throw new IllegalStateException("Mixin failed to shadow the \"LivingEntity.damageArmor(float)\" method!");
    }

    @Shadow
    public int func_70658_aO() {
        throw new IllegalStateException("Mixin failed to shadow the \"LivingEntity.getTotalArmorValue()\" method!");
    }

    @Shadow
    public double func_233637_b_(Attribute attribute) {
        throw new IllegalStateException("Mixin failed to shadow the \"LivingEntity.getAttributeValue(Attribute)\" method!");
    }
}

