/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.network;

import com.oblivioussp.spartanweaponry.api.APIAttributes;
import com.oblivioussp.spartanweaponry.util.Log;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraftforge.fml.network.NetworkEvent;

public class LongReachAttackPacket {
    private int entityID;
    private float velocity;

    public LongReachAttackPacket(int entityID, float velocity) {
        this.entityID = entityID;
        this.velocity = velocity;
    }

    public static void encode(LongReachAttackPacket packet, PacketBuffer buf) {
        buf.writeInt(packet.entityID);
        buf.writeFloat(packet.velocity);
    }

    public static LongReachAttackPacket decode(PacketBuffer buf) {
        return new LongReachAttackPacket(buf.readInt(), buf.readFloat());
    }

    public static class Handler {
        public static void handle(LongReachAttackPacket packet, Supplier<NetworkEvent.Context> ctx) {
            if (packet == null) {
                return;
            }
            ctx.get().enqueueWork(() -> {
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                Entity target = player.field_70170_p.func_73045_a(packet.entityID);
                if (player == null || target == null) {
                    return;
                }
                Log.debug("Victim of attack: " + target.func_145748_c_().getString());
                ItemStack weapon = player.func_184614_ca();
                if (weapon.func_190926_b()) {
                    return;
                }
                double reach = player.func_233637_b_(APIAttributes.ATTACK_REACH);
                if (reach == APIAttributes.ATTACK_REACH.func_111110_b()) {
                    return;
                }
                double reachSquared = reach * reach;
                double distanceSquared = player.func_70068_e(target);
                if (reachSquared >= distanceSquared) {
                    player.getPersistentData().func_74776_a("spartanweaponry_riding_velocity", packet.velocity);
                    player.func_71059_n(target);
                    Log.debug("Attacking victim!");
                }
                player.func_184609_a(Hand.MAIN_HAND);
                player.func_184821_cY();
            });
        }
    }
}

