/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.util;

import com.oblivioussp.spartanweaponry.client.gui.AlignmentHelper;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientConfig {
    public static final ClientConfig INSTANCE;
    public static final ForgeConfigSpec CONFIG_SPEC;
    public ForgeConfigSpec.BooleanValue disableNewCrosshairsCrossbow;
    public ForgeConfigSpec.BooleanValue disableNewCrosshairsThrowingWeapon;
    public ForgeConfigSpec.BooleanValue forceCompatibilityCrosshairs;
    public ForgeConfigSpec.EnumValue<AlignmentHelper.Alignment> quiverHudAlignment;
    public ForgeConfigSpec.IntValue quiverHudOffsetX;
    public ForgeConfigSpec.IntValue quiverHudOffsetY;

    public ClientConfig(ForgeConfigSpec.Builder builder) {
        builder.push("hud");
        this.disableNewCrosshairsCrossbow = builder.comment("Set to true to disable a new Crosshair for the Crossbow which visually shows inaccuracy, using the default Crosshair instead; false otherwise").translation("config.spartanweaponry.client.disable_new_crosshairs_crossbow").define("disable_new_crosshairs_crossbow", false);
        this.disableNewCrosshairsThrowingWeapon = builder.comment("Set to true to disable a new Crosshair for Throwing Weapons which show the charge for them, using the default Crosshair instead; false otherwise").translation("config.spartanweaponry.client.disable_new_crosshairs_throwing_weapons").define("disable_new_crosshairs_throwing_weapons", false);
        this.forceCompatibilityCrosshairs = builder.comment("Set to force compatibility crosshairs for Crosshairs and Throwing Weapons. This won't work if the new crosshairs are disabled").translation("config.spartanweaponry.client.force_compatibility_crosshairs").define("force_compatibility_crosshairs", false);
        this.quiverHudAlignment = builder.comment("Sets where the Quiver HUD Element should be aligned").translation("config.spartanweaponry.client.quiver_hud_alignment").defineEnum("quiver_hud_alignment", (Enum)AlignmentHelper.Alignment.BOTTOM_CENTER);
        this.quiverHudOffsetX = builder.comment("Sets where on the X-axis the Quiver HUD element should be off-set from it's alignment point").translation("config.spartanweaponry.client.quiver_hud_offset_x").defineInRange("quiver_hud_offset_x", -138, -400, 400);
        this.quiverHudOffsetY = builder.comment("Sets where on the Y-axis the Quiver HUD element should be off-set from it's alignment point").translation("config.spartanweaponry.client.quiver_hud_offset_y").defineInRange("quiver_hud_offset_y", 65, -400, 400);
        builder.pop();
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        INSTANCE = (ClientConfig)specPair.getLeft();
        CONFIG_SPEC = (ForgeConfigSpec)specPair.getRight();
    }
}

