/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanshields.enchantment;

import com.oblivioussp.spartanshields.enchantment.EnchantmentSS;
import com.oblivioussp.spartanshields.init.ModEnchantments;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;

public class SpikesEnchantment
extends EnchantmentSS {
    public SpikesEnchantment(Enchantment.Rarity rarityIn, EquipmentSlotType ... slots) {
        super(rarityIn, EnchantmentSS.TYPE_SHIELD, slots);
        this.setRegistryName("spikes");
    }

    public int func_77321_a(int enchantmentLevel) {
        return 10 + 20 * (enchantmentLevel - 1);
    }

    public int func_223551_b(int enchantmentLevel) {
        return super.func_77321_a(enchantmentLevel) + 50;
    }

    public int func_77325_b() {
        return 3;
    }

    @Override
    public void onUserAttacked(LivingEntity user, Entity attacker, float damage, int level) {
        Random random = user.func_70681_au();
        ItemStack itemStack = (ItemStack)EnchantmentHelper.func_222189_b((Enchantment)ModEnchantments.spikes, (LivingEntity)user).getValue();
        ItemStack activeStack = user.func_184607_cu();
        if (!activeStack.func_190926_b() && activeStack == itemStack) {
            if (SpikesEnchantment.shouldHit(level, random)) {
                float spikesDamage = SpikesEnchantment.getDamage(level, random);
                if (attacker != null) {
                    attacker.func_70097_a(DamageSource.func_92087_a((Entity)user), spikesDamage);
                }
                if (!itemStack.func_190926_b()) {
                    itemStack.func_222118_a(9, user, livingEntity -> livingEntity.func_213334_d(livingEntity.func_184600_cs()));
                }
            } else if (!itemStack.func_190926_b()) {
                itemStack.func_222118_a(3, user, livingEntity -> livingEntity.func_213334_d(livingEntity.func_184600_cs()));
            }
        }
    }

    public static boolean shouldHit(int level, Random rnd) {
        return level <= 0 ? false : rnd.nextFloat() < 0.2f * (float)level;
    }

    public static int getDamage(int level, Random rnd) {
        if (level == 1) {
            return 2;
        }
        return 2 + rnd.nextInt(level - 1);
    }
}

