/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanshields.event;

import com.oblivioussp.spartanshields.item.ShieldBaseItem;
import com.oblivioussp.spartanshields.network.NetworkHandler;
import com.oblivioussp.spartanshields.network.ShieldBashPacket;
import com.oblivioussp.spartanshields.util.Config;
import com.oblivioussp.spartanshields.util.Log;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ClientEventHandler {
    @SubscribeEvent
    public static void onMouseInputEvent(InputEvent.MouseInputEvent ev) {
        ClientEventHandler.checkForShieldBash();
    }

    @SubscribeEvent
    public static void onKeyboardInputEvent(InputEvent.KeyInputEvent ev) {
        ClientEventHandler.checkForShieldBash();
    }

    protected static void checkForShieldBash() {
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        if (Minecraft.func_71410_x().field_71441_e == null || Minecraft.func_71410_x().field_71462_r != null || Minecraft.func_71410_x().func_147113_T() || player == null) {
            return;
        }
        if (!((Boolean)Config.INSTANCE.disableShieldBash.get()).booleanValue() && player.func_184585_cz() && mc.field_71474_y.field_74312_F.func_151468_f()) {
            ItemStack shieldStack = ItemStack.field_190927_a;
            Hand shieldHand = null;
            if (!(player.func_184607_cu().func_77973_b() instanceof ShieldBaseItem)) {
                return;
            }
            shieldStack = player.func_184607_cu();
            shieldHand = player.func_184600_cs();
            if (player.func_184811_cZ().func_185141_a(shieldStack.func_77973_b())) {
                return;
            }
            RayTraceResult result = ClientEventHandler.getEntityMouseOverExtended(5.0f);
            if (result != null) {
                int entId = -1;
                boolean attackEntity = true;
                EntityRayTraceResult entityRayTrace = null;
                if (result instanceof EntityRayTraceResult) {
                    entityRayTrace = (EntityRayTraceResult)result;
                }
                if (entityRayTrace != null && entityRayTrace.func_216348_a() != null && entityRayTrace.func_216348_a() != player) {
                    Log.debug("Hit Entity with Shield Bash! - " + entityRayTrace.func_216348_a().toString());
                    entId = entityRayTrace.func_216348_a().func_145782_y();
                }
                if (entId == -1) {
                    entId = 0;
                    attackEntity = false;
                }
                player.func_184609_a(shieldHand);
                NetworkHandler.sendPacketToServer(new ShieldBashPacket(shieldHand, entId, attackEntity));
            }
        }
    }

    private static RayTraceResult getEntityMouseOverExtended(float reach) {
        BlockRayTraceResult result = null;
        Minecraft mc = Minecraft.func_71410_x();
        Entity viewEntity = mc.func_175606_aa();
        if (viewEntity != null && mc.field_71441_e != null) {
            AxisAlignedBB expBounds;
            double d0 = reach;
            RayTraceResult rayTrace = viewEntity.func_213324_a(d0, 0.0f, false);
            Vector3d eyePos = viewEntity.func_174824_e(0.0f);
            boolean flag = false;
            double d1 = d0;
            if (mc.field_71442_b.func_78749_i() && d1 < 6.0) {
                d0 = d1 = 6.0;
            } else if (d0 > (double)reach) {
                flag = true;
            }
            if (rayTrace != null) {
                d1 = rayTrace.func_216347_e().func_72436_e(eyePos);
            }
            Vector3d lookVec = viewEntity.func_70676_i(1.0f);
            Vector3d attackVec = eyePos.func_72441_c(lookVec.field_72450_a * d0, lookVec.field_72448_b * d0, lookVec.field_72449_c * d0);
            EntityRayTraceResult entityRayTrace = ProjectileHelper.func_221273_a((Entity)viewEntity, (Vector3d)eyePos, (Vector3d)attackVec, (AxisAlignedBB)(expBounds = viewEntity.func_174813_aQ().func_216361_a(lookVec.func_186678_a(d0)).func_72314_b(1.0, 1.0, 1.0)), entity -> !entity.func_175149_v() && entity.func_70067_L(), (double)d1);
            if (entityRayTrace != null) {
                Vector3d hitVec = entityRayTrace.func_216347_e();
                double d2 = eyePos.func_72436_e(hitVec);
                if (flag && d2 > (double)(reach * reach)) {
                    result = BlockRayTraceResult.func_216352_a((Vector3d)hitVec, (Direction)Direction.func_210769_a((double)lookVec.field_72450_a, (double)lookVec.field_72448_b, (double)lookVec.field_72449_c), (BlockPos)new BlockPos(hitVec));
                } else if (d2 < d1 || result == null) {
                    result = entityRayTrace;
                }
            } else {
                result = BlockRayTraceResult.func_216352_a((Vector3d)attackVec, (Direction)Direction.func_210769_a((double)lookVec.field_72450_a, (double)lookVec.field_72448_b, (double)lookVec.field_72449_c), (BlockPos)new BlockPos(attackVec));
            }
        }
        return result;
    }
}

