/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.lib.xz;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import me.lucko.spark.lib.xz.ArrayCache;
import me.lucko.spark.lib.xz.CorruptedInputException;
import me.lucko.spark.lib.xz.MemoryLimitException;
import me.lucko.spark.lib.xz.UnsupportedOptionsException;
import me.lucko.spark.lib.xz.XZIOException;
import me.lucko.spark.lib.xz.lz.LZDecoder;
import me.lucko.spark.lib.xz.lzma.LZMADecoder;
import me.lucko.spark.lib.xz.rangecoder.RangeDecoderFromStream;

public class LZMAInputStream
extends InputStream {
    public static final int DICT_SIZE_MAX = 0x7FFFFFF0;
    private InputStream in;
    private ArrayCache arrayCache;
    private LZDecoder lz;
    private RangeDecoderFromStream rc;
    private LZMADecoder lzma;
    private boolean endReached = false;
    private final byte[] tempBuf = new byte[1];
    private long remainingSize;
    private IOException exception = null;

    public static int getMemoryUsage(int n, byte by) throws UnsupportedOptionsException, CorruptedInputException {
        if (n < 0 || n > 0x7FFFFFF0) {
            throw new UnsupportedOptionsException("LZMA dictionary is too big for this implementation");
        }
        int n2 = by & 0xFF;
        if (n2 > 224) {
            throw new CorruptedInputException("Invalid LZMA properties byte");
        }
        int n3 = (n2 %= 45) / 9;
        int n4 = n2 - n3 * 9;
        return LZMAInputStream.getMemoryUsage(n, n4, n3);
    }

    public static int getMemoryUsage(int n, int n2, int n3) {
        if (n2 < 0 || n2 > 8 || n3 < 0 || n3 > 4) {
            throw new IllegalArgumentException("Invalid lc or lp");
        }
        return 10 + LZMAInputStream.getDictSize(n) / 1024 + (1536 << n2 + n3) / 1024;
    }

    private static int getDictSize(int n) {
        if (n < 0 || n > 0x7FFFFFF0) {
            throw new IllegalArgumentException("LZMA dictionary is too big for this implementation");
        }
        if (n < 4096) {
            n = 4096;
        }
        return n + 15 & 0xFFFFFFF0;
    }

    public LZMAInputStream(InputStream inputStream) throws IOException {
        this(inputStream, -1);
    }

    public LZMAInputStream(InputStream inputStream, ArrayCache arrayCache) throws IOException {
        this(inputStream, -1, arrayCache);
    }

    public LZMAInputStream(InputStream inputStream, int n) throws IOException {
        this(inputStream, n, ArrayCache.getDefaultCache());
    }

    public LZMAInputStream(InputStream inputStream, int n, ArrayCache arrayCache) throws IOException {
        int n2;
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        byte by = dataInputStream.readByte();
        int n3 = 0;
        for (int i = 0; i < 4; ++i) {
            n3 |= dataInputStream.readUnsignedByte() << 8 * i;
        }
        long l = 0L;
        for (n2 = 0; n2 < 8; ++n2) {
            l |= (long)dataInputStream.readUnsignedByte() << 8 * n2;
        }
        n2 = LZMAInputStream.getMemoryUsage(n3, by);
        if (n != -1 && n2 > n) {
            throw new MemoryLimitException(n2, n);
        }
        this.initialize(inputStream, l, by, n3, null, arrayCache);
    }

    public LZMAInputStream(InputStream inputStream, long l, byte by, int n) throws IOException {
        this.initialize(inputStream, l, by, n, null, ArrayCache.getDefaultCache());
    }

    public LZMAInputStream(InputStream inputStream, long l, byte by, int n, byte[] byArray) throws IOException {
        this.initialize(inputStream, l, by, n, byArray, ArrayCache.getDefaultCache());
    }

    public LZMAInputStream(InputStream inputStream, long l, byte by, int n, byte[] byArray, ArrayCache arrayCache) throws IOException {
        this.initialize(inputStream, l, by, n, byArray, arrayCache);
    }

    public LZMAInputStream(InputStream inputStream, long l, int n, int n2, int n3, int n4, byte[] byArray) throws IOException {
        this.initialize(inputStream, l, n, n2, n3, n4, byArray, ArrayCache.getDefaultCache());
    }

    public LZMAInputStream(InputStream inputStream, long l, int n, int n2, int n3, int n4, byte[] byArray, ArrayCache arrayCache) throws IOException {
        this.initialize(inputStream, l, n, n2, n3, n4, byArray, arrayCache);
    }

    private void initialize(InputStream inputStream, long l, byte by, int n, byte[] byArray, ArrayCache arrayCache) throws IOException {
        if (l < -1L) {
            throw new UnsupportedOptionsException("Uncompressed size is too big");
        }
        int n2 = by & 0xFF;
        if (n2 > 224) {
            throw new CorruptedInputException("Invalid LZMA properties byte");
        }
        int n3 = n2 / 45;
        int n4 = (n2 -= n3 * 9 * 5) / 9;
        int n5 = n2 - n4 * 9;
        if (n < 0 || n > 0x7FFFFFF0) {
            throw new UnsupportedOptionsException("LZMA dictionary is too big for this implementation");
        }
        this.initialize(inputStream, l, n5, n4, n3, n, byArray, arrayCache);
    }

    private void initialize(InputStream inputStream, long l, int n, int n2, int n3, int n4, byte[] byArray, ArrayCache arrayCache) throws IOException {
        if (l < -1L || n < 0 || n > 8 || n2 < 0 || n2 > 4 || n3 < 0 || n3 > 4) {
            throw new IllegalArgumentException();
        }
        this.in = inputStream;
        this.arrayCache = arrayCache;
        n4 = LZMAInputStream.getDictSize(n4);
        if (l >= 0L && (long)n4 > l) {
            n4 = LZMAInputStream.getDictSize((int)l);
        }
        this.lz = new LZDecoder(LZMAInputStream.getDictSize(n4), byArray, arrayCache);
        this.rc = new RangeDecoderFromStream(inputStream);
        this.lzma = new LZMADecoder(this.lz, this.rc, n, n2, n3);
        this.remainingSize = l;
    }

    public int read() throws IOException {
        return this.read(this.tempBuf, 0, 1) == -1 ? -1 : this.tempBuf[0] & 0xFF;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n + n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        if (this.in == null) {
            throw new XZIOException("Stream closed");
        }
        if (this.exception != null) {
            throw this.exception;
        }
        if (this.endReached) {
            return -1;
        }
        try {
            int n3 = 0;
            while (n2 > 0) {
                int n4 = n2;
                if (this.remainingSize >= 0L && this.remainingSize < (long)n2) {
                    n4 = (int)this.remainingSize;
                }
                this.lz.setLimit(n4);
                try {
                    this.lzma.decode();
                }
                catch (CorruptedInputException corruptedInputException) {
                    if (this.remainingSize != -1L || !this.lzma.endMarkerDetected()) {
                        throw corruptedInputException;
                    }
                    this.endReached = true;
                    this.rc.normalize();
                }
                int n5 = this.lz.flush(byArray, n);
                n += n5;
                n2 -= n5;
                n3 += n5;
                if (this.remainingSize >= 0L) {
                    this.remainingSize -= (long)n5;
                    assert (this.remainingSize >= 0L);
                    if (this.remainingSize == 0L) {
                        this.endReached = true;
                    }
                }
                if (!this.endReached) continue;
                if (!this.rc.isFinished() || this.lz.hasPending()) {
                    throw new CorruptedInputException();
                }
                this.putArraysToCache();
                return n3 == 0 ? -1 : n3;
            }
            return n3;
        }
        catch (IOException iOException) {
            this.exception = iOException;
            throw iOException;
        }
    }

    private void putArraysToCache() {
        if (this.lz != null) {
            this.lz.putArraysToCache(this.arrayCache);
            this.lz = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.in != null) {
            this.putArraysToCache();
            try {
                this.in.close();
            }
            finally {
                this.in = null;
            }
        }
    }
}

