/*
 * Decompiled with CFR 0.152.
 */
package com.thevortex.potionsmaster.render.util.xray;

import com.thevortex.potionsmaster.PotionsMaster;
import com.thevortex.potionsmaster.reference.Ores;
import com.thevortex.potionsmaster.render.util.BlockData;
import com.thevortex.potionsmaster.render.util.BlockInfo;
import com.thevortex.potionsmaster.render.util.BlockStore;
import com.thevortex.potionsmaster.render.util.WorldRegion;
import com.thevortex.potionsmaster.render.util.xray.Controller;
import com.thevortex.potionsmaster.render.util.xray.Render;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkSection;

public class RenderEnqueue
implements Runnable {
    private final WorldRegion box;

    public RenderEnqueue(WorldRegion region) {
        this.box = region;
    }

    public static void checkBlock(BlockPos pos, BlockState state, boolean add) {
        if (!Controller.drawOres() || Controller.getBlockStore().getStore().isEmpty()) {
            return;
        }
        String defaultState = state.func_177230_c().func_176223_P().toString();
        if (Controller.getBlockStore().getStore().containsKey(defaultState)) {
            if (!add) {
                Render.ores.remove((Object)new BlockInfo((Vector3i)pos, null, 0.0));
                return;
            }
            BlockData data = null;
            if (Controller.getBlockStore().getStore().containsKey(defaultState)) {
                data = Controller.getBlockStore().getStore().get(defaultState);
            }
            if (data == null) {
                return;
            }
            double alpha = Math.max(0.0, ((double)Controller.getRadius() - PotionsMaster.proxy.getClientPlayer().func_70092_e((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p())) / (double)Controller.getRadius() * 255.0);
            Render.ores.add(new BlockInfo((Vector3i)pos, data.getColor().getColor(), alpha));
        }
    }

    @Override
    public void run() {
        this.blockFinder();
    }

    private void blockFinder() {
        HashMap<UUID, BlockData> blocks = Controller.getBlockStore().getStore();
        if (blocks.isEmpty() && !Render.ores.isEmpty()) {
            Render.ores.clear();
        }
        World world = PotionsMaster.proxy.getClientPlayer().field_70170_p;
        PlayerEntity player = PotionsMaster.proxy.getClientPlayer();
        ArrayList<BlockInfo> renderQueue = new ArrayList<BlockInfo>();
        for (int chunkX = this.box.minChunkX; chunkX <= this.box.maxChunkX; ++chunkX) {
            int x = chunkX << 4;
            int lowBoundX = x < this.box.minX ? this.box.minX - x : 0;
            int highBoundX = x + 15 > this.box.maxX ? this.box.maxX - x : 15;
            for (int chunkZ = this.box.minChunkZ; chunkZ <= this.box.maxChunkZ; ++chunkZ) {
                if (!world.func_217354_b(chunkX, chunkZ)) continue;
                Chunk chunk = world.func_212866_a_(chunkX, chunkZ);
                ChunkSection[] extendsList = chunk.func_76587_i();
                int z = chunkZ << 4;
                int lowBoundZ = z < this.box.minZ ? this.box.minZ - z : 0;
                int highBoundZ = z + 15 > this.box.maxZ ? this.box.maxZ - z : 15;
                for (int curExtend = this.box.minChunkY; curExtend <= this.box.maxChunkY; ++curExtend) {
                    ChunkSection ebs = extendsList[curExtend];
                    if (ebs == null) continue;
                    int y = curExtend << 4;
                    int lowBoundY = y < this.box.minY ? this.box.minY - y : 0;
                    int highBoundY = y + 15 > this.box.maxY ? this.box.maxY - y : 15;
                    for (int i = lowBoundX; i <= highBoundX; ++i) {
                        for (int j = lowBoundY; j <= highBoundY; ++j) {
                            for (int k = lowBoundZ; k <= highBoundZ; ++k) {
                                BlockStore.BlockDataWithUUID dataWithUUID;
                                BlockState currentState = ebs.func_177485_a(i, j, k);
                                ResourceLocation block = currentState.func_177230_c().getRegistryName();
                                if (block == null) continue;
                                if (currentState.func_177230_c().getTags().contains(Ores.DIAMOND) || currentState.func_177230_c().getRegistryName().func_110623_a().contains("ore_other_diamond")) {
                                    block = Ores.DIAMOND;
                                }
                                if (currentState.func_177230_c().getTags().contains(Ores.LAPIS) || currentState.func_177230_c().getRegistryName().func_110623_a().contains("ore_other_lapis")) {
                                    block = Ores.LAPIS;
                                }
                                if (currentState.func_177230_c().getTags().contains(Ores.ALUMINIUM) || currentState.func_177230_c().getRegistryName().func_110623_a().contains("ore_other_aluminum")) {
                                    block = Ores.ALUMINIUM;
                                }
                                if (currentState.func_177230_c().getTags().contains(Ores.COPPER) || currentState.func_177230_c().getRegistryName().func_110623_a().contains("ore_other_copper")) {
                                    block = Ores.COPPER;
                                }
                                if (currentState.func_177230_c().getTags().contains(Ores.TIN) || currentState.func_177230_c().getRegistryName().func_110623_a().contains("ore_other_tin")) {
                                    block = Ores.TIN;
                                }
                                if (currentState.func_177230_c().getTags().contains(Ores.LEAD) || currentState.func_177230_c().getRegistryName().func_110623_a().contains("ore_other_lead")) {
                                    block = Ores.LEAD;
                                }
                                if (currentState.func_177230_c().getTags().contains(Ores.SILVER) || currentState.func_177230_c().getRegistryName().func_110623_a().contains("ore_other_silver")) {
                                    block = Ores.SILVER;
                                }
                                if (currentState.func_177230_c().getTags().contains(Ores.GOLD) || currentState.func_177230_c().getRegistryName().func_110623_a().contains("nether_gold_ore")) {
                                    block = Ores.GOLD;
                                }
                                if (currentState.func_177230_c().getTags().contains(Ores.URANIUM) || currentState.func_177230_c().getRegistryName().func_110623_a().contains("ore_other_uranium")) {
                                    block = Ores.URANIUM;
                                }
                                if (currentState.func_177230_c().getTags().contains(Ores.NICKEL) || currentState.func_177230_c().getRegistryName().func_110623_a().contains("ore_other_nickel")) {
                                    block = Ores.NICKEL;
                                }
                                if (currentState.func_177230_c().getTags().contains(Ores.IRON) || currentState.func_177230_c().getRegistryName().func_110623_a().contains("ore_other_iron")) {
                                    block = Ores.IRON;
                                }
                                if (currentState.func_177230_c().getTags().contains(Ores.OSMIUM) || currentState.func_177230_c().getRegistryName().func_110623_a().contains("ore_other_osmium")) {
                                    block = Ores.OSMIUM;
                                }
                                if (currentState.func_177230_c().getTags().contains(Ores.ZINC) || currentState.func_177230_c().getRegistryName().func_110623_a().contains("ore_other_zinc")) {
                                    block = Ores.ZINC;
                                }
                                if (currentState.func_177230_c().getTags().contains(Ores.EMERALD)) {
                                    block = Ores.EMERALD;
                                }
                                if (currentState.func_177230_c().getTags().contains(Ores.COAL) || currentState.func_177230_c().getRegistryName().func_110623_a().contains("ore_other_coal")) {
                                    block = Ores.COAL;
                                }
                                if (currentState.func_177230_c().getTags().contains(Ores.REDSTONE) || currentState.func_177230_c().getRegistryName().func_110623_a().contains("ore_other_redstone")) {
                                    block = Ores.REDSTONE;
                                }
                                if (currentState.func_177230_c().getTags().contains(Ores.QUARTZ) || currentState.func_177230_c().getRegistryName().func_110623_a().contains("quartz")) {
                                    block = Ores.QUARTZ;
                                }
                                if (currentState.func_177230_c().getTags().contains(Ores.BISMUTH)) {
                                    block = Ores.BISMUTH;
                                }
                                if (currentState.func_177230_c().getTags().contains(Ores.CRIMSONIRON)) {
                                    block = Ores.CRIMSONIRON;
                                }
                                if (currentState.func_177230_c().getTags().contains(Ores.PLATINUM) || currentState.func_177230_c().getRegistryName().func_110623_a().contains("ore_other_platinum")) {
                                    block = Ores.PLATINUM;
                                }
                                if (currentState.func_177230_c().getTags().contains(Ores.NETHERITE)) {
                                    block = Ores.NETHERITE;
                                }
                                if (currentState.func_177230_c().getTags().contains(Ores.ALLTHEMODIUM)) {
                                    block = Ores.ALLTHEMODIUM;
                                }
                                if (currentState.func_177230_c().getTags().contains(Ores.VIBRANIUM)) {
                                    block = Ores.VIBRANIUM;
                                }
                                if (currentState.func_177230_c().getTags().contains(Ores.UNOBTAINIUM)) {
                                    block = Ores.UNOBTAINIUM;
                                }
                                if ((dataWithUUID = Controller.getBlockStore().getStoreByReference(block.toString())) == null || dataWithUUID.getBlockData() == null || !dataWithUUID.getBlockData().isDrawing()) continue;
                                double alpha = Math.max(0.0, (double)Controller.getRadius() - PotionsMaster.proxy.getClientPlayer().func_70092_e((double)(x + i), (double)(y + j), (double)(z + k)) / (double)(Controller.getRadius() / 4));
                                renderQueue.add(new BlockInfo(x + i, y + j, z + k, dataWithUUID.getBlockData().getColor().getColor(), alpha));
                            }
                        }
                    }
                }
            }
        }
        renderQueue.sort((t, t1) -> Double.compare(t1.func_177951_i(new Vector3i(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_())), t.func_177951_i(new Vector3i(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_()))));
        Render.ores.clear();
        Render.ores.addAll(renderQueue);
    }
}

