/*
 * Decompiled with CFR 0.152.
 */
package owmii.losttrinkets.api.trinket;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.registries.ForgeRegistries;
import owmii.losttrinkets.api.LostTrinketsAPI;
import owmii.losttrinkets.api.player.PlayerData;
import owmii.losttrinkets.api.trinket.ITargetingTrinket;
import owmii.losttrinkets.api.trinket.ITickableTrinket;
import owmii.losttrinkets.api.trinket.ITrinket;
import owmii.losttrinkets.api.trinket.Trinket;
import owmii.losttrinkets.config.Configs;

public class Trinkets
implements INBTSerializable<CompoundNBT> {
    private final List<ITrinket> available = new ArrayList<ITrinket>();
    private final List<ITrinket> active = new ArrayList<ITrinket>();
    private final List<ITickableTrinket> tickable = new ArrayList<ITickableTrinket>();
    private final List<ITargetingTrinket> targeting = new ArrayList<ITargetingTrinket>();
    private final PlayerData data;
    private int slots = 1;
    private boolean slotsSet;

    public Trinkets(PlayerData data) {
        this.data = data;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a("slots", this.slots);
        nbt.func_74757_a("slots_set", this.slotsSet);
        ListNBT availableTrinkets = new ListNBT();
        this.available.forEach(trinket -> {
            CompoundNBT nbt1 = new CompoundNBT();
            ResourceLocation location = trinket.getItem().getRegistryName();
            Objects.requireNonNull(location);
            nbt1.func_74778_a("trinket", location.toString());
            availableTrinkets.add((Object)nbt1);
        });
        nbt.func_218657_a("available_trinkets", (INBT)availableTrinkets);
        ListNBT activeTrinkets = new ListNBT();
        this.active.forEach(trinket -> {
            CompoundNBT nbt1 = new CompoundNBT();
            ResourceLocation location = trinket.getItem().getRegistryName();
            Objects.requireNonNull(location);
            nbt1.func_74778_a("trinket", location.toString());
            activeTrinkets.add((Object)nbt1);
        });
        nbt.func_218657_a("active_trinkets", (INBT)activeTrinkets);
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.slots = nbt.func_74762_e("slots");
        this.slotsSet = nbt.func_74767_n("slots_set");
        ListNBT availableTrinkets = nbt.func_150295_c("available_trinkets", 10);
        this.available.clear();
        for (int i = 0; i < availableTrinkets.size(); ++i) {
            CompoundNBT nbt1 = availableTrinkets.func_150305_b(i);
            Item trinket = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(nbt1.func_74779_i("trinket")));
            if (!(trinket instanceof ITrinket)) continue;
            this.available.add((ITrinket)trinket);
        }
        ListNBT activeTrinkets = nbt.func_150295_c("active_trinkets", 10);
        this.active.clear();
        this.tickable.clear();
        this.targeting.clear();
        for (int i = 0; i < activeTrinkets.size(); ++i) {
            CompoundNBT nbt1 = activeTrinkets.func_150305_b(i);
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(nbt1.func_74779_i("trinket")));
            if (!(item instanceof ITrinket)) continue;
            ITrinket trinket = (ITrinket)item;
            if (this.active.size() >= this.slots) continue;
            this.active.add(trinket);
            if (trinket instanceof ITickableTrinket) {
                this.tickable.add((ITickableTrinket)trinket);
            }
            if (!(trinket instanceof ITargetingTrinket)) continue;
            this.targeting.add((ITargetingTrinket)trinket);
        }
    }

    public boolean unlockSlot() {
        if (this.slots < (Integer)Configs.GENERAL.maxSlots.get()) {
            ++this.slots;
            this.data.setSync(true);
            return true;
        }
        return false;
    }

    public int getSlots() {
        return this.slots;
    }

    public void initSlots(int slots) {
        if (!this.slotsSet) {
            this.setSlots(slots);
            this.slotsSet = true;
        }
    }

    public void setSlots(int slots) {
        this.slots = slots;
        this.data.setSync(true);
    }

    public boolean clear() {
        if (!this.available.isEmpty() || !this.active.isEmpty()) {
            this.available.clear();
            this.active.clear();
            this.data.setSync(true);
            return true;
        }
        return false;
    }

    public boolean give(ITrinket trinket) {
        if (!this.has(trinket)) {
            this.available.add(trinket);
            this.data.setSync(true);
            return true;
        }
        return false;
    }

    public boolean setActive(ITrinket trinket, PlayerEntity player) {
        if (this.isAvailable(trinket)) {
            this.forceActive(trinket, player);
            this.available.remove(trinket);
            return true;
        }
        return false;
    }

    public boolean setInactive(ITrinket trinket, PlayerEntity player) {
        if (this.isActive(trinket)) {
            this.available.add(trinket);
            this.active.remove(trinket);
            if (trinket instanceof ITickableTrinket) {
                this.tickable.remove(trinket);
            }
            if (trinket instanceof ITargetingTrinket) {
                this.targeting.remove(trinket);
            }
            if (trinket instanceof Trinket) {
                ((Trinket)trinket).removeAttributes(player);
            }
            trinket.onDeactivated(player.field_70170_p, player.func_233580_cy_(), player);
            this.data.setSync(true);
            return true;
        }
        return false;
    }

    public boolean forceActive(ITrinket trinket, PlayerEntity player) {
        if (!this.isActive(trinket) && this.active.size() < this.slots) {
            this.active.add(trinket);
            if (trinket instanceof ITickableTrinket) {
                this.tickable.add((ITickableTrinket)trinket);
            }
            if (trinket instanceof ITargetingTrinket) {
                this.targeting.add((ITargetingTrinket)trinket);
            }
            if (trinket instanceof Trinket) {
                ((Trinket)trinket).applyAttributes(player);
            }
            trinket.onActivated(player.field_70170_p, player.func_233580_cy_(), player);
            this.data.setSync(true);
            return true;
        }
        return false;
    }

    public void removeDisabled(PlayerEntity player) {
        this.getActiveTrinkets().stream().filter(LostTrinketsAPI.get()::isDisabled).collect(Collectors.toList()).forEach(trinket -> this.setInactive((ITrinket)trinket, player));
        if (this.getAvailableTrinkets().removeIf(LostTrinketsAPI.get()::isDisabled)) {
            this.data.setSync(true);
        }
    }

    public boolean has(ITrinket trinket) {
        return this.isActive(trinket) || this.isAvailable(trinket);
    }

    public boolean isActive(ITrinket trinket) {
        return this.active.contains(trinket);
    }

    public boolean isAvailable(ITrinket trinket) {
        return this.available.contains(trinket);
    }

    public List<ITrinket> getActiveTrinkets() {
        return this.active;
    }

    public List<ITrinket> getAvailableTrinkets() {
        return this.available;
    }

    public List<ITickableTrinket> getTickable() {
        return this.tickable;
    }

    public List<ITargetingTrinket> getTargeting() {
        return this.targeting;
    }
}

