/*
 * Decompiled with CFR 0.152.
 */
package owmii.losttrinkets.client.handler.hud;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.StringUtils;
import owmii.lib.util.Ticker;
import owmii.losttrinkets.client.handler.hud.Toast;
import owmii.losttrinkets.client.screen.Textures;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class HudHandler {
    private static final List<Toast> TOASTS = new ArrayList<Toast>();
    private static Ticker ticker = new Ticker(60.0);
    @Nullable
    private static Toast toast;

    @SubscribeEvent
    public static void tick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71441_e == null && !TOASTS.isEmpty()) {
                TOASTS.clear();
                toast = null;
            }
            Iterator<Toast> itr = TOASTS.iterator();
            while (itr.hasNext()) {
                Toast b = itr.next();
                if (!b.getTicker().ended()) {
                    toast = b;
                    if (ticker.ended()) {
                        b.getTicker().onward();
                    }
                    ticker.add(5.0);
                } else {
                    ticker.back(5.0);
                    if (ticker.getTicks() <= 0.0) {
                        toast = null;
                        itr.remove();
                    }
                }
                if (toast == null) continue;
                break;
            }
            if (TOASTS.isEmpty()) {
                toast = null;
            }
        }
    }

    @SubscribeEvent
    public static void renderHud(RenderGameOverlayEvent.Post event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL && mc.field_71462_r == null) {
            HudHandler.render(event.getMatrixStack(), mc, event.getWindow().func_198107_o(), event.getWindow().func_198087_p());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void gui(GuiScreenEvent.DrawScreenEvent.Post event) {
        Minecraft mc = Minecraft.func_71410_x();
        HudHandler.render(event.getMatrixStack(), mc, event.getGui().field_230708_k_, event.getGui().field_230709_l_);
    }

    static void render(MatrixStack matrix, Minecraft mc, int width, int height) {
        if (toast != null) {
            RenderSystem.pushMatrix();
            RenderSystem.translated((double)((float)width / 2.0f - (float)Textures.TOAST.getWidth() / 2.0f), (double)(-56.0 + ticker.getTicks()), (double)0.0);
            Textures.TOAST.draw(matrix, 0, 0);
            RenderSystem.pushMatrix();
            RenderSystem.translated((double)41.0, (double)5.0, (double)0.0);
            mc.field_71466_p.func_238421_b_(matrix, I18n.func_135052_a((String)"gui.losttrinkets.trinket.unlocked", (Object[])new Object[0]), 0.0f, 5.0f, new Color(16759407).getRGB());
            String s = I18n.func_135052_a((String)toast.getTrinket().getItem().func_77658_a(), (Object[])new Object[0]);
            s = StringUtils.abbreviate((String)s, (int)20);
            mc.field_71466_p.func_238421_b_(matrix, s, 0.0f, 18.0f, 15779557);
            RenderSystem.popMatrix();
            RenderSystem.pushMatrix();
            RenderSystem.translated((double)5.0, (double)5.0, (double)0.0);
            RenderSystem.scaled((double)2.0, (double)2.0, (double)2.0);
            mc.func_175599_af().func_180450_b(new ItemStack((IItemProvider)toast.getTrinket()), 0, 0);
            RenderSystem.popMatrix();
            RenderSystem.popMatrix();
        }
    }

    public static void add(Toast toast) {
        TOASTS.add(toast);
    }
}

