/*
 * Decompiled with CFR 0.152.
 */
package owmii.losttrinkets.handler;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import owmii.losttrinkets.LostTrinkets;
import owmii.losttrinkets.api.LostTrinketsAPI;
import owmii.losttrinkets.api.player.PlayerData;
import owmii.losttrinkets.api.trinket.Trinket;
import owmii.losttrinkets.api.trinket.Trinkets;
import owmii.losttrinkets.config.Configs;
import owmii.losttrinkets.network.packet.SyncDataPacket;

@Mod.EventBusSubscriber
public class DataManager
implements ICapabilitySerializable<CompoundNBT> {
    private final PlayerData data = new PlayerData();
    private final LazyOptional<PlayerData> holder = LazyOptional.of(() -> this.data);

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == PlayerData.CAP) {
            return this.holder.cast();
        }
        return LazyOptional.empty();
    }

    public CompoundNBT serializeNBT() {
        return this.data.serializeNBT();
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.data.deserializeNBT(nbt);
    }

    public static void register() {
        CapabilityManager.INSTANCE.register(PlayerData.class, (Capability.IStorage)new Capability.IStorage<PlayerData>(){

            @Nullable
            public INBT writeNBT(Capability<PlayerData> capability, PlayerData instance, Direction side) {
                return null;
            }

            public void readNBT(Capability<PlayerData> capability, PlayerData instance, Direction side, INBT nbt) {
            }
        }, PlayerData::new);
    }

    @SubscribeEvent
    public static void attachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof PlayerEntity) {
            event.addCapability(new ResourceLocation("losttrinkets", "player_data"), (ICapabilityProvider)new DataManager());
        }
    }

    @SubscribeEvent
    public static void clone(PlayerEvent.Clone event) {
        PlayerEntity oldPlayer = event.getOriginal();
        PlayerEntity player = event.getPlayer();
        PlayerData oldData = LostTrinketsAPI.getData(oldPlayer);
        PlayerData newData = LostTrinketsAPI.getData(player);
        newData.deserializeNBT(oldData.serializeNBT());
        Trinkets trinkets = LostTrinketsAPI.getTrinkets(player);
        trinkets.getActiveTrinkets().forEach(trinket -> {
            if (trinket instanceof Trinket) {
                ((Trinket)trinket).applyAttributes(player);
            }
        });
        if (!event.isWasDeath()) {
            player.func_70606_j(oldPlayer.func_110143_aJ());
        }
    }

    @SubscribeEvent
    public static void update(LivingEvent.LivingUpdateEvent event) {
        ServerPlayerEntity player;
        PlayerData data;
        LivingEntity entity = event.getEntityLiving();
        if (entity instanceof ServerPlayerEntity && (data = LostTrinketsAPI.getData((PlayerEntity)(player = (ServerPlayerEntity)entity))).isSync()) {
            LostTrinkets.NET.toTrackingAndSelf((Object)new SyncDataPacket((PlayerEntity)player), (Entity)player);
            data.setSync(false);
        }
    }

    @SubscribeEvent
    public static void changedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        DataManager.sync(event.getPlayer());
    }

    @SubscribeEvent
    public static void loggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Trinkets trinkets = LostTrinketsAPI.getTrinkets(event.getPlayer());
        trinkets.initSlots((Integer)Configs.GENERAL.startSlots.get());
        trinkets.removeDisabled(event.getPlayer());
        DataManager.sync(event.getPlayer());
    }

    @SubscribeEvent
    public static void loggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        PlayerEntity player = event.getPlayer();
        PlayerData data = LostTrinketsAPI.getData(player);
        data.wasFlying = player.field_71075_bZ.field_75100_b;
    }

    @SubscribeEvent
    public static void respawn(PlayerEvent.PlayerRespawnEvent event) {
        DataManager.sync(event.getPlayer());
    }

    @SubscribeEvent
    public static void trackPlayer(PlayerEvent.StartTracking event) {
        Entity target = event.getTarget();
        if (target instanceof ServerPlayerEntity) {
            LostTrinkets.NET.toClient((Object)new SyncDataPacket((PlayerEntity)((ServerPlayerEntity)target)), event.getPlayer());
        }
    }

    static void sync(PlayerEntity player) {
        if (player instanceof ServerPlayerEntity) {
            LostTrinkets.NET.toClient((Object)new SyncDataPacket(player), player);
        }
    }
}

