/*
 * Decompiled with CFR 0.152.
 */
package owmii.losttrinkets.handler;

import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.IAngerable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.brain.Brain;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import owmii.losttrinkets.api.LostTrinketsAPI;

@Mod.EventBusSubscriber
public class TargetHandler {
    public static boolean preventTargeting(LivingEntity attacker, @Nullable LivingEntity target) {
        if (attacker instanceof MobEntity) {
            MobEntity mob = (MobEntity)attacker;
            if (target instanceof PlayerEntity) {
                PlayerEntity player = (PlayerEntity)target;
                if (!mob.func_184222_aU()) {
                    return false;
                }
                boolean notAttacked = !player.equals((Object)mob.func_70643_av()) && !player.equals((Object)mob.func_110142_aN().func_94550_c());
                return LostTrinketsAPI.getTrinkets(player).getTargeting().stream().anyMatch(trinket -> trinket.preventTargeting(mob, player, notAttacked));
            }
        }
        return false;
    }

    public static <T> Optional<T> getBrainMemorySafe(Brain<?> brain, MemoryModuleType<T> type) {
        return brain.func_218191_a(type) ? brain.func_218207_c(type) : Optional.empty();
    }

    @SubscribeEvent
    public static void setTarget(LivingSetAttackTargetEvent event) {
        LivingEntity living = event.getEntityLiving();
        if (living instanceof MobEntity && TargetHandler.preventTargeting(living, event.getTarget())) {
            MobEntity mob = (MobEntity)living;
            mob.func_70624_b(null);
        }
    }

    @SubscribeEvent
    public static void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        LivingEntity living = event.getEntityLiving();
        if (living instanceof MobEntity) {
            IAngerable angerable;
            UUID targetUUID;
            MobEntity mob = (MobEntity)living;
            if (mob instanceof IAngerable && (targetUUID = (angerable = (IAngerable)mob).func_230257_G__()) != null && TargetHandler.preventTargeting((LivingEntity)mob, (LivingEntity)mob.field_70170_p.func_217371_b(targetUUID))) {
                angerable.func_241356_K__();
            }
            if (TargetHandler.preventTargeting((LivingEntity)mob, mob.func_70638_az())) {
                mob.func_70624_b(null);
            }
            Brain brain = mob.func_213375_cj();
            TargetHandler.getBrainMemorySafe(brain, MemoryModuleType.field_234103_o_).ifPresent(target -> {
                if (TargetHandler.preventTargeting((LivingEntity)mob, target)) {
                    brain.func_218189_b(MemoryModuleType.field_234103_o_);
                }
            });
        }
    }
}

