/*
 * Decompiled with CFR 0.152.
 */
package owmii.losttrinkets.handler;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import owmii.lib.util.Ticker;
import owmii.losttrinkets.api.trinket.ITrinket;
import owmii.losttrinkets.config.Configs;
import owmii.losttrinkets.handler.UnlockManager;
import owmii.losttrinkets.impl.LostTrinketsAPIImpl;

@Mod.EventBusSubscriber
public class UnlockHandler {
    private static final Map<UUID, Type> MAP = new HashMap<UUID, Type>();
    private static final Ticker DELAY = new Ticker(10.0);
    private static boolean flag;

    @SubscribeEvent
    public static void tick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.side == LogicalSide.SERVER) {
            PlayerEntity player = event.player;
            List<ITrinket> trinkets = LostTrinketsAPIImpl.UNLOCK_QUEUE.get(player.func_110124_au());
            if (trinkets != null) {
                trinkets.forEach(trinket -> UnlockManager.unlock(player, trinket, false));
            }
            LostTrinketsAPIImpl.UNLOCK_QUEUE.remove(player.func_110124_au());
            Iterator<UUID> itr = LostTrinketsAPIImpl.WEIGHTED_UNLOCK_QUEUE.iterator();
            while (itr.hasNext()) {
                if (!itr.next().equals(player.func_110124_au())) continue;
                UnlockManager.unlock(player, false);
                itr.remove();
            }
            UnlockHandler.checkUnlocks(player);
        }
    }

    private static void checkUnlocks(PlayerEntity player) {
        if (((Boolean)Configs.GENERAL.unlockEnabled.get()).booleanValue()) {
            UUID id = player.func_110124_au();
            if (DELAY.isEmpty() && MAP.containsKey(id)) {
                if (player.field_70170_p.field_73012_v.nextInt(MAP.get(id).getRandom()) == 0) {
                    UnlockManager.unlock(player, true);
                }
                flag = true;
            }
            if (flag) {
                DELAY.onward();
                MAP.remove(id);
                if (DELAY.ended()) {
                    DELAY.reset();
                    flag = false;
                }
            }
        }
    }

    private static void queueUnlock(PlayerEntity player, Type type) {
        if (!player.field_70170_p.field_72995_K && !(player instanceof FakePlayer)) {
            MAP.put(player.func_110124_au(), type);
        }
    }

    public static void trade(PlayerEntity player) {
        if (((Boolean)Configs.GENERAL.unlockEnabled.get()).booleanValue() && ((Boolean)Configs.GENERAL.tradingUnlockEnabled.get()).booleanValue() && !player.field_70170_p.field_72995_K) {
            UnlockHandler.queueUnlock(player, Type.TRADING);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void kill(LivingDeathEvent event) {
        if (((Boolean)Configs.GENERAL.unlockEnabled.get()).booleanValue()) {
            Entity entity = event.getSource().func_76346_g();
            LivingEntity target = event.getEntityLiving();
            if (entity instanceof PlayerEntity) {
                PlayerEntity player = (PlayerEntity)entity;
                if (!player.field_70170_p.field_72995_K) {
                    if (target.func_184222_aU()) {
                        if (((Boolean)Configs.GENERAL.killingUnlockEnabled.get()).booleanValue()) {
                            UnlockHandler.queueUnlock(player, Type.KILL);
                        }
                    } else if (((Boolean)Configs.GENERAL.bossKillingUnlockEnabled.get()).booleanValue()) {
                        UnlockHandler.queueUnlock(player, Type.BOSS_KILL);
                    }
                }
            }
        }
    }

    public static void checkBlockHarvest(PlayerEntity player, World world, BlockPos pos, BlockState state) {
        if (((Boolean)Configs.GENERAL.unlockEnabled.get()).booleanValue() && !player.field_70170_p.field_72995_K) {
            if (Tags.Blocks.ORES.func_230235_a_((Object)state.func_177230_c())) {
                if (((Boolean)Configs.GENERAL.oresMiningUnlockEnabled.get()).booleanValue()) {
                    UnlockHandler.queueUnlock(player, Type.ORE_MINE);
                }
            } else if (BlockTags.field_226152_ab_.func_230235_a_((Object)state.func_177230_c())) {
                if (((Boolean)Configs.GENERAL.farmingUnlockEnabled.get()).booleanValue()) {
                    UnlockHandler.queueUnlock(player, Type.FARM_HARVEST);
                }
            } else if (BlockTags.field_200031_h.func_230235_a_((Object)state.func_177230_c()) && ((Boolean)Configs.GENERAL.woodCuttingUnlockEnabled.get()).booleanValue()) {
                UnlockHandler.queueUnlock(player, Type.WOOD_CUTTING);
            }
        }
    }

    @SubscribeEvent
    public static void useHoe(UseHoeEvent event) {
        if (((Boolean)Configs.GENERAL.unlockEnabled.get()).booleanValue() && ((Boolean)Configs.GENERAL.farmingUnlockEnabled.get()).booleanValue()) {
            PlayerEntity player = event.getPlayer();
            if (!player.field_70170_p.field_72995_K) {
                UnlockHandler.queueUnlock(player, Type.FARM_HARVEST);
            }
        }
    }

    @SubscribeEvent
    public static void bonemeal(BonemealEvent event) {
        if (((Boolean)Configs.GENERAL.unlockEnabled.get()).booleanValue() && ((Boolean)Configs.GENERAL.farmingUnlockEnabled.get()).booleanValue()) {
            PlayerEntity player = event.getPlayer();
            if (!player.field_70170_p.field_72995_K) {
                UnlockHandler.queueUnlock(player, Type.FARM_HARVEST);
            }
        }
    }

    static enum Type {
        KILL,
        BOSS_KILL,
        ORE_MINE,
        WOOD_CUTTING,
        FARM_HARVEST,
        TRADING;


        public int getRandom() {
            if (this == KILL) {
                return (Integer)Configs.GENERAL.killing.get();
            }
            if (this == BOSS_KILL) {
                return (Integer)Configs.GENERAL.bossKilling.get();
            }
            if (this == ORE_MINE) {
                return (Integer)Configs.GENERAL.oresMining.get();
            }
            if (this == TRADING) {
                return (Integer)Configs.GENERAL.trading.get();
            }
            if (this == FARM_HARVEST) {
                return (Integer)Configs.GENERAL.farming.get();
            }
            if (this == WOOD_CUTTING) {
                return (Integer)Configs.GENERAL.woodCutting.get();
            }
            return Integer.MAX_VALUE;
        }
    }
}

