/*
 * Decompiled with CFR 0.152.
 */
package owmii.losttrinkets.item.trinkets;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.concurrent.TickDelayedTask;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import owmii.losttrinkets.api.LostTrinketsAPI;
import owmii.losttrinkets.api.trinket.Rarity;
import owmii.losttrinkets.api.trinket.Trinket;
import owmii.losttrinkets.api.trinket.Trinkets;
import owmii.losttrinkets.item.Itms;

public class OctopusLegTrinket
extends Trinket<OctopusLegTrinket> {
    public OctopusLegTrinket(Rarity rarity, Item.Properties properties) {
        super(rarity, properties);
    }

    public static void onAttack(LivingAttackEvent event) {
        LivingEntity entity = event.getEntityLiving();
        World world = entity.func_130014_f_();
        if (!(world instanceof ServerWorld)) {
            return;
        }
        DamageSource source = event.getSource();
        if (source == null) {
            return;
        }
        Entity immediateSource = source.func_76364_f();
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            Trinkets trinkets = LostTrinketsAPI.getTrinkets(player);
            if (immediateSource instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)immediateSource;
                if (trinkets.isActive(Itms.OCTOPUS_LEG)) {
                    MinecraftServer server = ((ServerWorld)world).func_73046_m();
                    server.func_212871_a_((Runnable)new TickDelayedTask(server.func_71259_af(), () -> OctopusLegTrinket.disarm(world, living)));
                }
            }
        }
    }

    private static void disarm(World world, LivingEntity living) {
        if (!living.func_70089_S()) {
            return;
        }
        ItemStack stack = living.func_184614_ca();
        if (!stack.func_190926_b() && world.field_73012_v.nextInt(5) == 0) {
            ItemStack stack1 = stack.func_77946_l();
            if (stack1.func_77984_f() && !stack1.func_77951_h()) {
                int damage = stack1.func_77958_k();
                if (damage > 10) {
                    damage /= 2;
                    damage = 10 + world.field_73012_v.nextInt(damage);
                }
                stack1.func_196085_b(damage);
            }
            living.func_199701_a_(stack1);
            living.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
        }
    }
}

