/*
 * Decompiled with CFR 0.152.
 */
package owmii.losttrinkets.network.packet;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import owmii.lib.network.IPacket;
import owmii.losttrinkets.api.LostTrinketsAPI;
import owmii.losttrinkets.api.trinket.ITrinket;
import owmii.losttrinkets.api.trinket.Trinkets;

public class SetActivePacket
implements IPacket<SetActivePacket> {
    private int trinket;

    public SetActivePacket(int trinket) {
        this.trinket = trinket;
    }

    public SetActivePacket() {
        this(0);
    }

    public void encode(SetActivePacket msg, PacketBuffer buffer) {
        buffer.writeInt(msg.trinket);
    }

    public SetActivePacket decode(PacketBuffer buffer) {
        return new SetActivePacket(buffer.readInt());
    }

    public void handle(SetActivePacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Trinkets trinkets;
            List<ITrinket> items;
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null && !(items = (trinkets = LostTrinketsAPI.getTrinkets((PlayerEntity)player)).getAvailableTrinkets()).isEmpty()) {
                trinkets.setActive(items.get(msg.trinket), (PlayerEntity)player);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

