/*
 * Decompiled with CFR 0.152.
 */
package owmii.losttrinkets.network.packet;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import owmii.lib.network.IPacket;
import owmii.losttrinkets.api.LostTrinketsAPI;
import owmii.losttrinkets.api.trinket.ITrinket;
import owmii.losttrinkets.api.trinket.Trinkets;

public class SetInactivePacket
implements IPacket<SetInactivePacket> {
    private int trinket;

    public SetInactivePacket(int trinket) {
        this.trinket = trinket;
    }

    public SetInactivePacket() {
        this(0);
    }

    public void encode(SetInactivePacket msg, PacketBuffer buffer) {
        buffer.writeInt(msg.trinket);
    }

    public SetInactivePacket decode(PacketBuffer buffer) {
        return new SetInactivePacket(buffer.readInt());
    }

    public void handle(SetInactivePacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Trinkets trinkets;
            List<ITrinket> items;
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null && !(items = (trinkets = LostTrinketsAPI.getTrinkets((PlayerEntity)player)).getActiveTrinkets()).isEmpty()) {
                trinkets.setInactive(items.get(msg.trinket), (PlayerEntity)player);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

