/*
 * Decompiled with CFR 0.152.
 */
package owmii.losttrinkets.network.packet;

import java.util.Objects;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import owmii.lib.client.util.MC;
import owmii.lib.network.IPacket;
import owmii.losttrinkets.api.LostTrinketsAPI;
import owmii.losttrinkets.api.player.PlayerData;
import owmii.losttrinkets.client.screen.Screens;

public class SyncDataPacket
implements IPacket<SyncDataPacket> {
    private final UUID uuid;
    private final CompoundNBT nbt;

    protected SyncDataPacket(UUID uuid, CompoundNBT nbt) {
        this.uuid = uuid;
        this.nbt = nbt;
    }

    public SyncDataPacket() {
        this(new UUID(0L, 0L), new CompoundNBT());
    }

    public SyncDataPacket(PlayerEntity player) {
        this(player.func_110124_au(), LostTrinketsAPI.getData(player).serializeNBT());
    }

    public void encode(SyncDataPacket msg, PacketBuffer buffer) {
        buffer.func_179252_a(msg.uuid);
        buffer.func_150786_a(msg.nbt);
    }

    public SyncDataPacket decode(PacketBuffer buffer) {
        return new SyncDataPacket(buffer.func_179253_g(), Objects.requireNonNull(buffer.func_150793_b()));
    }

    public void handle(SyncDataPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> MC.world().ifPresent(world -> {
            PlayerEntity player = world.func_217371_b(msg.uuid);
            if (player != null) {
                PlayerData data = LostTrinketsAPI.getData(player);
                data.deserializeNBT(msg.nbt);
                Screens.checkScreenRefresh();
            }
        }));
        ctx.get().setPacketHandled(true);
    }
}

