/*
 * Decompiled with CFR 0.152.
 */
package owmii.losttrinkets.network.packet;

import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import owmii.lib.client.util.MC;
import owmii.lib.network.IPacket;
import owmii.losttrinkets.api.LostTrinketsAPI;
import owmii.losttrinkets.api.player.PlayerData;

public class SyncFlyPacket
implements IPacket<SyncFlyPacket> {
    private boolean fly;

    public SyncFlyPacket(boolean fly) {
        this.fly = fly;
    }

    public SyncFlyPacket() {
        this(false);
    }

    public void encode(SyncFlyPacket msg, PacketBuffer buffer) {
        buffer.writeBoolean(msg.fly);
    }

    public SyncFlyPacket decode(PacketBuffer buffer) {
        return new SyncFlyPacket(buffer.readBoolean());
    }

    public void handle(SyncFlyPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> MC.player().ifPresent(player -> {
            PlayerData data = LostTrinketsAPI.getData(player);
            data.allowFlying = msg.fly;
            player.field_71075_bZ.field_75101_c = msg.fly;
            if (!msg.fly) {
                player.field_71075_bZ.field_75100_b = false;
            }
        }));
        ctx.get().setPacketHandled(true);
    }
}

