/*
 * Decompiled with CFR 0.152.
 */
package ironfurnaces.blocks;

import ironfurnaces.init.Registration;
import ironfurnaces.tileentity.BlockWirelessEnergyHeaterTile;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.network.NetworkHooks;

public class BlockWirelessEnergyHeater
extends Block {
    public static final String HEATER = "heater";

    public BlockWirelessEnergyHeater(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j(this.func_176223_P());
    }

    @Nullable
    public ToolType getHarvestTool(BlockState state) {
        return ToolType.PICKAXE;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new BlockWirelessEnergyHeaterTile();
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, FluidState fluid) {
        if (!world.field_72995_K) {
            BlockWirelessEnergyHeaterTile te = (BlockWirelessEnergyHeaterTile)world.func_175625_s(pos);
            ItemStack stack = new ItemStack((IItemProvider)Registration.HEATER.get());
            if (te.func_145818_k_()) {
                stack.func_200302_a(te.func_145748_c_());
            }
            if (te.getEnergy() > 0) {
                stack.func_196082_o().func_74768_a("Energy", te.getEnergy());
            }
            if (!player.func_184812_l_()) {
                InventoryHelper.func_180173_a((World)world, (double)te.func_174877_v().func_177958_n(), (double)te.func_174877_v().func_177956_o(), (double)te.func_174877_v().func_177952_p(), (ItemStack)stack);
            }
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        if (entity != null) {
            BlockWirelessEnergyHeaterTile te = (BlockWirelessEnergyHeaterTile)world.func_175625_s(pos);
            if (stack.func_82837_s()) {
                te.setCustomName(stack.func_151000_E());
            }
            if (stack.func_77942_o()) {
                te.getCapability(CapabilityEnergy.ENERGY).ifPresent(h -> h.receiveEnergy(stack.func_77978_p().func_74762_e("Energy"), false));
            }
        }
    }

    public ActionResultType func_225533_a_(BlockState p_225533_1_, World world, BlockPos pos, PlayerEntity player, Hand p_225533_5_, BlockRayTraceResult p_225533_6_) {
        if (!world.field_72995_K) {
            this.interactWith(world, pos, player);
        }
        return ActionResultType.SUCCESS;
    }

    private void interactWith(World world, BlockPos pos, PlayerEntity player) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof INamedContainerProvider) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((INamedContainerProvider)tileEntity), (BlockPos)tileEntity.func_174877_v());
        }
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState oldState, boolean p_196243_5_) {
        if (state.func_177230_c() != oldState.func_177230_c()) {
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof BlockWirelessEnergyHeaterTile) {
                InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((BlockWirelessEnergyHeaterTile)te));
                world.func_175666_e(pos, (Block)this);
            }
            super.func_196243_a(state, world, pos, oldState, p_196243_5_);
        }
    }
}

