/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.particle;

import com.bobmowzie.mowziesmobs.client.render.MMRenderType;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SpriteTexturedParticle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ParticleCloud
extends SpriteTexturedParticle {
    private final float red;
    private final float green;
    private final float blue;
    private final float scale;
    private final EnumCloudBehavior behavior;
    private final float airDrag;

    public ParticleCloud(ClientWorld world, double x, double y, double z, double vx, double vy, double vz, double r, double g, double b, double scale, int duration, EnumCloudBehavior behavior, double airDrag) {
        super(world, x, y, z);
        this.scale = (float)scale * 0.5f * 0.1f;
        this.field_70547_e = duration;
        this.field_187129_i = vx * 0.5;
        this.field_187130_j = vy * 0.5;
        this.field_187131_k = vz * 0.5;
        this.red = (float)r;
        this.green = (float)g;
        this.blue = (float)b;
        this.behavior = behavior;
        this.field_190014_F = this.field_190015_G = (float)((double)this.field_187136_p.nextInt(4) * Math.PI / 2.0);
        this.airDrag = (float)airDrag;
    }

    public IParticleRenderType func_217558_b() {
        return MMRenderType.PARTICLE_SHEET_TRANSLUCENT_NO_DEPTH;
    }

    public void func_189213_a() {
        super.func_189213_a();
        this.field_187129_i *= (double)this.airDrag;
        this.field_187130_j *= (double)this.airDrag;
        this.field_187131_k *= (double)this.airDrag;
    }

    public void func_225606_a_(IVertexBuilder buffer, ActiveRenderInfo renderInfo, float partialTicks) {
        float var = ((float)this.field_70546_d + partialTicks) / (float)this.field_70547_e;
        this.field_82339_as = 0.2f * (float)(1.0 - Math.exp(5.0f * (var - 1.0f)) - Math.pow(2000.0, -var));
        if ((double)this.field_82339_as < 0.01) {
            this.field_82339_as = 0.01f;
        }
        this.field_70544_f = this.behavior == EnumCloudBehavior.SHRINK ? this.scale * (1.0f - 0.7f * var + 0.3f) : (this.behavior == EnumCloudBehavior.GROW ? this.scale * (0.7f * var + 0.3f) : this.scale);
        super.func_225606_a_(buffer, renderInfo, partialTicks);
    }

    public static class CloudData
    implements IParticleData {
        public static final IParticleData.IDeserializer<CloudData> DESERIALIZER = new IParticleData.IDeserializer<CloudData>(){

            public CloudData deserialize(ParticleType<CloudData> particleTypeIn, StringReader reader) throws CommandSyntaxException {
                reader.expect(' ');
                float r = (float)reader.readDouble();
                reader.expect(' ');
                float g = (float)reader.readDouble();
                reader.expect(' ');
                float b = (float)reader.readDouble();
                reader.expect(' ');
                float scale = (float)reader.readDouble();
                reader.expect(' ');
                int duration = reader.readInt();
                reader.expect(' ');
                float airDrag = (float)reader.readDouble();
                return new CloudData(particleTypeIn, r, g, b, scale, duration, EnumCloudBehavior.CONSTANT, airDrag);
            }

            public CloudData read(ParticleType<CloudData> particleTypeIn, PacketBuffer buffer) {
                return new CloudData(particleTypeIn, buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readInt(), EnumCloudBehavior.CONSTANT, buffer.readFloat());
            }
        };
        private final ParticleType<CloudData> type;
        private final float r;
        private final float g;
        private final float b;
        private final float scale;
        private final int duration;
        private final EnumCloudBehavior behavior;
        private final float airDrag;

        public CloudData(ParticleType<CloudData> type, float r, float g, float b, float scale, int duration, EnumCloudBehavior behavior, float airDrag) {
            this.type = type;
            this.r = r;
            this.g = g;
            this.b = b;
            this.scale = scale;
            this.behavior = behavior;
            this.airDrag = airDrag;
            this.duration = duration;
        }

        public void func_197553_a(PacketBuffer buffer) {
            buffer.writeFloat(this.r);
            buffer.writeFloat(this.g);
            buffer.writeFloat(this.b);
            buffer.writeFloat(this.scale);
            buffer.writeInt(this.duration);
            buffer.writeFloat(this.airDrag);
        }

        public String func_197555_a() {
            return String.format(Locale.ROOT, "%s %.2f %.2f %.2f %.2f %d %.2f", Registry.field_212632_u.func_177774_c(this.func_197554_b()), Float.valueOf(this.r), Float.valueOf(this.g), Float.valueOf(this.b), Float.valueOf(this.scale), this.duration, Float.valueOf(this.airDrag));
        }

        public ParticleType<CloudData> func_197554_b() {
            return this.type;
        }

        @OnlyIn(value=Dist.CLIENT)
        public float getR() {
            return this.r;
        }

        @OnlyIn(value=Dist.CLIENT)
        public float getG() {
            return this.g;
        }

        @OnlyIn(value=Dist.CLIENT)
        public float getB() {
            return this.b;
        }

        @OnlyIn(value=Dist.CLIENT)
        public float getScale() {
            return this.scale;
        }

        @OnlyIn(value=Dist.CLIENT)
        public EnumCloudBehavior getBehavior() {
            return this.behavior;
        }

        @OnlyIn(value=Dist.CLIENT)
        public int getDuration() {
            return this.duration;
        }

        @OnlyIn(value=Dist.CLIENT)
        public float getAirDrag() {
            return this.airDrag;
        }

        public static Codec<CloudData> CODEC(ParticleType<CloudData> particleType) {
            return RecordCodecBuilder.create(codecBuilder -> codecBuilder.group((App)Codec.FLOAT.fieldOf("r").forGetter(CloudData::getR), (App)Codec.FLOAT.fieldOf("g").forGetter(CloudData::getG), (App)Codec.FLOAT.fieldOf("b").forGetter(CloudData::getB), (App)Codec.FLOAT.fieldOf("scale").forGetter(CloudData::getScale), (App)Codec.STRING.fieldOf("behavior").forGetter(cloudData -> cloudData.getBehavior().toString()), (App)Codec.INT.fieldOf("duration").forGetter(CloudData::getDuration), (App)Codec.FLOAT.fieldOf("airdrag").forGetter(CloudData::getAirDrag)).apply((Applicative)codecBuilder, (r, g, b, scale, behavior, duration, airdrag) -> new CloudData(particleType, r.floatValue(), g.floatValue(), b.floatValue(), scale.floatValue(), (int)duration, EnumCloudBehavior.valueOf(behavior), airdrag.floatValue())));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final class CloudFactory
    implements IParticleFactory<CloudData> {
        private final IAnimatedSprite spriteSet;

        public CloudFactory(IAnimatedSprite sprite) {
            this.spriteSet = sprite;
        }

        public Particle makeParticle(CloudData typeIn, ClientWorld worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            ParticleCloud particleCloud = new ParticleCloud(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, typeIn.getR(), typeIn.getG(), typeIn.getB(), typeIn.getScale(), typeIn.getDuration(), typeIn.getBehavior(), typeIn.getAirDrag());
            particleCloud.func_217566_b(this.spriteSet);
            particleCloud.func_70538_b(typeIn.getR(), typeIn.getG(), typeIn.getB());
            return particleCloud;
        }
    }

    public static enum EnumCloudBehavior {
        SHRINK,
        GROW,
        CONSTANT;

    }
}

