/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.ability;

import com.bobmowzie.mowziesmobs.MowziesMobs;
import com.bobmowzie.mowziesmobs.server.ability.Ability;
import com.bobmowzie.mowziesmobs.server.ability.AbilityType;
import com.bobmowzie.mowziesmobs.server.ability.abilities.FireballAbility;
import com.bobmowzie.mowziesmobs.server.ability.abilities.IceBreathAbility;
import com.bobmowzie.mowziesmobs.server.ability.abilities.SimpleAnimationAbility;
import com.bobmowzie.mowziesmobs.server.ability.abilities.SolarBeamAbility;
import com.bobmowzie.mowziesmobs.server.ability.abilities.SpawnBoulderAbility;
import com.bobmowzie.mowziesmobs.server.ability.abilities.SunstrikeAbility;
import com.bobmowzie.mowziesmobs.server.ability.abilities.TunnelingAbility;
import com.bobmowzie.mowziesmobs.server.ability.abilities.WroughtAxeSlamAbility;
import com.bobmowzie.mowziesmobs.server.ability.abilities.WroughtAxeSwingAbility;
import com.bobmowzie.mowziesmobs.server.capability.AbilityCapability;
import com.bobmowzie.mowziesmobs.server.capability.CapabilityHandler;
import com.bobmowzie.mowziesmobs.server.message.MessageInterruptAbility;
import com.bobmowzie.mowziesmobs.server.message.MessagePlayerUseAbility;
import com.bobmowzie.mowziesmobs.server.message.MessageUseAbility;
import javax.annotation.Nullable;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.fml.network.PacketDistributor;
import org.apache.commons.lang3.ArrayUtils;

public enum AbilityHandler {
    INSTANCE;

    public static final AbilityType<FireballAbility> FIREBALL_ABILITY;
    public static final AbilityType<SunstrikeAbility> SUNSTRIKE_ABILITY;
    public static final AbilityType<SolarBeamAbility> SOLAR_BEAM_ABILITY;
    public static final AbilityType<WroughtAxeSwingAbility> WROUGHT_AXE_SWING_ABILITY;
    public static final AbilityType<WroughtAxeSlamAbility> WROUGHT_AXE_SLAM_ABILITY;
    public static final AbilityType<IceBreathAbility> ICE_BREATH_ABILITY;
    public static final AbilityType<SpawnBoulderAbility> SPAWN_BOULDER_ABILITY;
    public static final AbilityType<TunnelingAbility> TUNNELING_ABILITY;
    public static final AbilityType<SimpleAnimationAbility> HIT_BOULDER_ABILITY;
    public static final AbilityType<SimpleAnimationAbility> BACKSTAB_ABILITY;
    public static final AbilityType<?>[] PLAYER_ABILITIES;

    @Nullable
    public AbilityCapability.IAbilityCapability getAbilityCapability(LivingEntity entity) {
        return CapabilityHandler.getCapability((Entity)entity, AbilityCapability.AbilityProvider.ABILITY_CAPABILITY);
    }

    @Nullable
    public Ability getAbility(LivingEntity entity, AbilityType<?> abilityType) {
        AbilityCapability.IAbilityCapability abilityCapability = this.getAbilityCapability(entity);
        if (abilityCapability != null) {
            return abilityCapability.getAbilityMap().get(abilityType);
        }
        return null;
    }

    public <T extends LivingEntity> void sendAbilityMessage(T entity, AbilityType<?> abilityType) {
        Ability instance;
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        AbilityCapability.IAbilityCapability abilityCapability = this.getAbilityCapability(entity);
        if (abilityCapability != null && (instance = abilityCapability.getAbilityMap().get(abilityType)).canUse()) {
            abilityCapability.activateAbility(entity, abilityType);
            MowziesMobs.NETWORK.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)new MessageUseAbility(entity.func_145782_y(), ArrayUtils.indexOf((Object[])abilityCapability.getAbilityTypesOnEntity(entity), abilityType)));
        }
    }

    public <T extends LivingEntity> void sendInterruptAbilityMessage(T entity, AbilityType<?> abilityType) {
        Ability instance;
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        AbilityCapability.IAbilityCapability abilityCapability = this.getAbilityCapability(entity);
        if (abilityCapability != null && (instance = abilityCapability.getAbilityMap().get(abilityType)).isUsing()) {
            instance.interrupt();
            MowziesMobs.NETWORK.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)new MessageInterruptAbility(entity.func_145782_y(), ArrayUtils.indexOf((Object[])abilityCapability.getAbilityTypesOnEntity(entity), abilityType)));
        }
    }

    public <T extends PlayerEntity> void sendPlayerTryAbilityMessage(T entity, AbilityType<?> ability) {
        if (!entity.field_70170_p.field_72995_K || !(entity instanceof ClientPlayerEntity)) {
            return;
        }
        AbilityCapability.IAbilityCapability abilityCapability = this.getAbilityCapability((LivingEntity)entity);
        if (abilityCapability != null) {
            MowziesMobs.NETWORK.sendToServer((Object)new MessagePlayerUseAbility(ArrayUtils.indexOf((Object[])abilityCapability.getAbilityTypesOnEntity((LivingEntity)entity), ability)));
        }
    }

    static {
        FIREBALL_ABILITY = new AbilityType<FireballAbility>("fireball", FireballAbility::new);
        SUNSTRIKE_ABILITY = new AbilityType<SunstrikeAbility>("sunstrike", SunstrikeAbility::new);
        SOLAR_BEAM_ABILITY = new AbilityType<SolarBeamAbility>("solar_beam", SolarBeamAbility::new);
        WROUGHT_AXE_SWING_ABILITY = new AbilityType<WroughtAxeSwingAbility>("wrought_axe_swing", WroughtAxeSwingAbility::new);
        WROUGHT_AXE_SLAM_ABILITY = new AbilityType<WroughtAxeSlamAbility>("wrought_axe_slam", WroughtAxeSlamAbility::new);
        ICE_BREATH_ABILITY = new AbilityType<IceBreathAbility>("ice_breath", IceBreathAbility::new);
        SPAWN_BOULDER_ABILITY = new AbilityType<SpawnBoulderAbility>("spawn_boulder", SpawnBoulderAbility::new);
        TUNNELING_ABILITY = new AbilityType<TunnelingAbility>("tunneling", TunnelingAbility::new);
        HIT_BOULDER_ABILITY = new AbilityType<SimpleAnimationAbility>("hit_boulder", (type, player) -> new SimpleAnimationAbility(type, player, "hit_boulder", 10, false, false));
        BACKSTAB_ABILITY = new AbilityType<SimpleAnimationAbility>("backstab", (type, player) -> new SimpleAnimationAbility(type, player, "backstab", 12, true, true));
        PLAYER_ABILITIES = new AbilityType[]{SUNSTRIKE_ABILITY, SOLAR_BEAM_ABILITY, WROUGHT_AXE_SWING_ABILITY, WROUGHT_AXE_SLAM_ABILITY, ICE_BREATH_ABILITY, SPAWN_BOULDER_ABILITY, TUNNELING_ABILITY, HIT_BOULDER_ABILITY, BACKSTAB_ABILITY};
    }
}

