/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.ai.animation;

import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationAttackAI;
import com.bobmowzie.mowziesmobs.server.entity.MowzieEntity;
import com.ilexiconn.llibrary.server.animation.Animation;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.SoundEvent;

public class AnimationAreaAttackAI<T extends MowzieEntity>
extends AnimationAttackAI<T> {
    private final float arc;
    private final float height;
    private final boolean faceTarget;

    public AnimationAreaAttackAI(T entity, Animation animation, SoundEvent attackSound, SoundEvent hitSound, float applyKnockback, float range, float height, float arc, float damageMultiplier, int damageFrame) {
        this(entity, animation, attackSound, hitSound, applyKnockback, range, height, arc, damageMultiplier, damageFrame, true);
    }

    public AnimationAreaAttackAI(T entity, Animation animation, SoundEvent attackSound, SoundEvent hitSound, float applyKnockback, float range, float height, float arc, float damageMultiplier, int damageFrame, boolean faceTarget) {
        super(entity, animation, attackSound, hitSound, applyKnockback, range, damageMultiplier, damageFrame);
        this.arc = arc;
        this.height = height;
        this.faceTarget = faceTarget;
        if (faceTarget) {
            this.func_220684_a(EnumSet.of(Goal.Flag.LOOK));
        }
    }

    @Override
    public void func_75249_e() {
        super.func_75249_e();
    }

    @Override
    public void func_75246_d() {
        if (this.faceTarget && this.entity.getAnimationTick() < this.damageFrame && this.entityTarget != null) {
            this.entity.func_70625_a((Entity)this.entityTarget, 30.0f, 30.0f);
        } else if (this.entity.getAnimationTick() == this.damageFrame) {
            this.hitEntities();
        }
    }

    public void hitEntities() {
        List<LivingEntity> entitiesHit = this.entity.getEntityLivingBaseNearby(this.range, this.height, this.range, this.range);
        boolean hit = false;
        for (LivingEntity entityHit : entitiesHit) {
            float entityHitAngle = (float)((Math.atan2(entityHit.func_226281_cx_() - this.entity.func_226281_cx_(), entityHit.func_226277_ct_() - this.entity.func_226277_ct_()) * 57.29577951308232 - 90.0) % 360.0);
            float entityAttackingAngle = this.entity.field_70761_aq % 360.0f;
            if (entityHitAngle < 0.0f) {
                entityHitAngle += 360.0f;
            }
            if (entityAttackingAngle < 0.0f) {
                entityAttackingAngle += 360.0f;
            }
            float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
            float entityHitDistance = (float)Math.sqrt((entityHit.func_226281_cx_() - this.entity.func_226281_cx_()) * (entityHit.func_226281_cx_() - this.entity.func_226281_cx_()) + (entityHit.func_226277_ct_() - this.entity.func_226277_ct_()) * (entityHit.func_226277_ct_() - this.entity.func_226277_ct_())) - entityHit.func_213311_cf() / 2.0f;
            if (!(entityHitDistance <= this.range && entityRelativeAngle <= this.arc / 2.0f && entityRelativeAngle >= -this.arc / 2.0f || entityRelativeAngle >= 360.0f - this.arc / 2.0f) && !(entityRelativeAngle <= -360.0f + this.arc / 2.0f)) continue;
            this.entity.attackEntityAsMob((Entity)entityHit, this.damageMultiplier, this.applyKnockbackMultiplier);
            this.onAttack(entityHit, this.damageMultiplier, this.applyKnockbackMultiplier);
            hit = true;
        }
        if (hit && this.hitSound != null) {
            this.entity.func_184185_a(this.hitSound, 1.0f, 1.0f);
        }
        if (this.attackSound != null) {
            this.entity.func_184185_a(this.attackSound, 1.0f, 1.0f);
        }
    }
}

