/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity.effects;

import com.bobmowzie.mowziesmobs.server.entity.EntityHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntityCameraShake
extends Entity {
    private static final DataParameter<Float> RADIUS = EntityDataManager.func_187226_a(EntityCameraShake.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> MAGNITUDE = EntityDataManager.func_187226_a(EntityCameraShake.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Integer> DURATION = EntityDataManager.func_187226_a(EntityCameraShake.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> FADE_DURATION = EntityDataManager.func_187226_a(EntityCameraShake.class, (IDataSerializer)DataSerializers.field_187192_b);

    public EntityCameraShake(EntityType<?> type, World world) {
        super(type, world);
    }

    public EntityCameraShake(World world, Vector3d position, float radius, float magnitude, int duration, int fadeDuration) {
        super((EntityType)EntityHandler.CAMERA_SHAKE.get(), world);
        this.setRadius(radius);
        this.setMagnitude(magnitude);
        this.setDuration(duration);
        this.setFadeDuration(fadeDuration);
        this.func_70107_b(position.func_82615_a(), position.func_82617_b(), position.func_82616_c());
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getShakeAmount(PlayerEntity player, float delta) {
        float ticksDelta = (float)this.field_70173_aa + delta;
        float timeFrac = 1.0f - (ticksDelta - (float)this.getDuration()) / ((float)this.getFadeDuration() + 1.0f);
        float baseAmount = ticksDelta < (float)this.getDuration() ? this.getMagnitude() : timeFrac * timeFrac * this.getMagnitude();
        Vector3d playerPos = player.func_174824_e(delta);
        float distFrac = (float)(1.0 - MathHelper.func_151237_a((double)(this.func_213303_ch().func_72438_d(playerPos) / (double)this.getRadius()), (double)0.0, (double)1.0));
        return baseAmount * distFrac * distFrac;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa > this.getDuration() + this.getFadeDuration()) {
            this.func_70106_y();
        }
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(RADIUS, (Object)Float.valueOf(10.0f));
        this.func_184212_Q().func_187214_a(MAGNITUDE, (Object)Float.valueOf(1.0f));
        this.func_184212_Q().func_187214_a(DURATION, (Object)0);
        this.func_184212_Q().func_187214_a(FADE_DURATION, (Object)5);
    }

    public float getRadius() {
        return ((Float)this.func_184212_Q().func_187225_a(RADIUS)).floatValue();
    }

    public void setRadius(float radius) {
        this.func_184212_Q().func_187227_b(RADIUS, (Object)Float.valueOf(radius));
    }

    public float getMagnitude() {
        return ((Float)this.func_184212_Q().func_187225_a(MAGNITUDE)).floatValue();
    }

    public void setMagnitude(float magnitude) {
        this.func_184212_Q().func_187227_b(MAGNITUDE, (Object)Float.valueOf(magnitude));
    }

    public int getDuration() {
        return (Integer)this.func_184212_Q().func_187225_a(DURATION);
    }

    public void setDuration(int duration) {
        this.func_184212_Q().func_187227_b(DURATION, (Object)duration);
    }

    public int getFadeDuration() {
        return (Integer)this.func_184212_Q().func_187225_a(FADE_DURATION);
    }

    public void setFadeDuration(int fadeDuration) {
        this.func_184212_Q().func_187227_b(FADE_DURATION, (Object)fadeDuration);
    }

    protected void func_70037_a(CompoundNBT compound) {
        this.setRadius(compound.func_74760_g("radius"));
        this.setMagnitude(compound.func_74760_g("magnitude"));
        this.setDuration(compound.func_74762_e("duration"));
        this.setFadeDuration(compound.func_74762_e("fade_duration"));
        this.field_70173_aa = compound.func_74762_e("ticks_existed");
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74776_a("radius", this.getRadius());
        compound.func_74776_a("magnitude", this.getMagnitude());
        compound.func_74768_a("duration", this.getDuration());
        compound.func_74768_a("fade_duration", this.getFadeDuration());
        compound.func_74768_a("ticks_existed", this.field_70173_aa);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public static void cameraShake(World world, Vector3d position, float radius, float magnitude, int duration, int fadeDuration) {
        if (!world.field_72995_K) {
            EntityCameraShake cameraShake = new EntityCameraShake(world, position, radius, magnitude, duration, fadeDuration);
            world.func_217376_c((Entity)cameraShake);
        }
    }
}

