/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity.effects;

import com.bobmowzie.mowziesmobs.MowziesMobs;
import com.bobmowzie.mowziesmobs.client.particle.ParticleOrb;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.entity.LeaderSunstrikeImmune;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.EntityBarako;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.SlabBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.network.play.server.SEntityTeleportPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.SlabType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntitySunstrike
extends Entity
implements IEntityAdditionalSpawnData {
    public static final int STRIKE_EXPLOSION = 35;
    private static final int STRIKE_LENGTH = 43;
    private static final int STRIKE_LINGER = 1243;
    private int prevStrikeTime;
    private int strikeTime;
    private LivingEntity caster;
    private static final DataParameter<Integer> VARIANT_LEAST = EntityDataManager.func_187226_a(EntitySunstrike.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> VARIANT_MOST = EntityDataManager.func_187226_a(EntitySunstrike.class, (IDataSerializer)DataSerializers.field_187192_b);

    public EntitySunstrike(EntityType<? extends EntitySunstrike> type, World world) {
        super(type, world);
        this.field_70158_ak = true;
    }

    public EntitySunstrike(EntityType<? extends EntitySunstrike> type, World world, LivingEntity caster, int x, int y, int z) {
        this(type, world);
        this.caster = caster;
        this.func_70107_b((float)x + 0.5f, (float)y + 1.0625f, (float)z + 0.5f);
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(VARIANT_LEAST, (Object)0);
        this.func_184212_Q().func_187214_a(VARIANT_MOST, (Object)0);
    }

    public float getStrikeTime(float delta) {
        return this.getActualStrikeTime(delta) / 43.0f;
    }

    public float getStrikeDrawTime(float delta) {
        return this.getActualStrikeTime(delta) / 35.0f;
    }

    public float getStrikeDamageTime(float delta) {
        return (this.getActualStrikeTime(delta) - 35.0f) / 8.0f;
    }

    public boolean isStrikeDrawing(float delta) {
        return this.getActualStrikeTime(delta) < 35.0f;
    }

    public boolean isLingering(float delta) {
        return this.getActualStrikeTime(delta) > 40.0f;
    }

    public boolean isStriking(float delta) {
        return this.getActualStrikeTime(delta) < 43.0f;
    }

    private float getActualStrikeTime(float delta) {
        return (float)this.prevStrikeTime + (float)(this.strikeTime - this.prevStrikeTime) * delta;
    }

    private void setStrikeTime(int strikeTime) {
        this.prevStrikeTime = this.strikeTime = strikeTime;
    }

    public boolean isStriking() {
        return this.isStriking(1.0f);
    }

    public long getVariant() {
        return (long)((Integer)this.func_184212_Q().func_187225_a(VARIANT_MOST)).intValue() << 32 | (long)((Integer)this.func_184212_Q().func_187225_a(VARIANT_LEAST)).intValue() & 0xFFFFFFFFL;
    }

    private void setVariant(long variant) {
        this.func_184212_Q().func_187227_b(VARIANT_MOST, (Object)((int)(variant >> 32)));
        this.func_184212_Q().func_187227_b(VARIANT_LEAST, (Object)((int)variant));
    }

    public boolean func_70067_L() {
        return false;
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_70112_a(double distance) {
        return distance < 1024.0;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.prevStrikeTime = this.strikeTime;
        if (this.field_70170_p.field_72995_K) {
            if (this.strikeTime == 0) {
                MowziesMobs.PROXY.playSunstrikeSound(this);
            } else if (this.strikeTime < 25) {
                float time = this.getStrikeTime(1.0f);
                int timeBonus = (int)(time * 5.0f);
                int orbCount = this.field_70146_Z.nextInt(4 + timeBonus) + timeBonus + 1;
                while (orbCount-- > 0) {
                    float theta = this.field_70146_Z.nextFloat() * ((float)Math.PI * 2);
                    float min = 0.2f;
                    float max = 1.9f;
                    float r = this.field_70146_Z.nextFloat() * 1.6999999f + 0.2f;
                    float ox = r * MathHelper.func_76134_b((float)theta);
                    float oz = r * MathHelper.func_76126_a((float)theta);
                    float minY = 0.1f;
                    float oy = this.field_70146_Z.nextFloat() * (time * 6.0f - 0.1f) + 0.1f;
                    this.field_70170_p.func_195594_a((IParticleData)new ParticleOrb.OrbData((float)this.func_226277_ct_(), (float)this.func_226281_cx_()), this.func_226277_ct_() + (double)ox, this.func_226278_cu_() + (double)oy, this.func_226281_cx_() + (double)oz, 0.0, 0.0, 0.0);
                }
            } else if (this.strikeTime > 35) {
                this.smolder();
            } else if (this.strikeTime == 35) {
                this.spawnExplosionParticles(10);
            }
        } else {
            this.moveDownToGround();
            if (this.strikeTime >= 1243 || !this.field_70170_p.func_175710_j(this.func_233580_cy_())) {
                this.func_70106_y();
            } else if (this.strikeTime == 35) {
                this.damageEntityLivingBaseNearby(3.0);
            }
        }
        ++this.strikeTime;
    }

    public void moveDownToGround() {
        BlockRayTraceResult hitResult;
        RayTraceResult rayTrace = this.rayTrace(this);
        if (rayTrace.func_216346_c() == RayTraceResult.Type.BLOCK && (hitResult = (BlockRayTraceResult)rayTrace).func_216354_b() == Direction.UP) {
            BlockState hitBlock = this.field_70170_p.func_180495_p(hitResult.func_216350_a());
            if (this.strikeTime > 43 && hitBlock != this.field_70170_p.func_180495_p(this.func_233580_cy_().func_177977_b())) {
                this.func_70106_y();
            }
            if (hitBlock.func_177230_c() instanceof SlabBlock && hitBlock.func_177229_b((Property)BlockStateProperties.field_208145_at) == SlabType.BOTTOM) {
                this.func_70107_b(this.func_226277_ct_(), (float)hitResult.func_216350_a().func_177956_o() + 1.0625f - 0.5f, this.func_226281_cx_());
            } else {
                this.func_70107_b(this.func_226277_ct_(), (float)hitResult.func_216350_a().func_177956_o() + 1.0625f, this.func_226281_cx_());
            }
            if (this.field_70170_p instanceof ServerWorld) {
                ((ServerWorld)this.field_70170_p).func_72863_F().func_217218_b((Entity)this, (IPacket)new SEntityTeleportPacket((Entity)this));
            }
        }
    }

    public void damageEntityLivingBaseNearby(double radius) {
        AxisAlignedBB region = new AxisAlignedBB(this.func_226277_ct_() - radius, this.func_226278_cu_() - 0.5, this.func_226281_cx_() - radius, this.func_226277_ct_() + radius, Double.POSITIVE_INFINITY, this.func_226281_cx_() + radius);
        List entities = this.field_70170_p.func_72839_b((Entity)this, region);
        double radiusSq = radius * radius;
        for (Entity entity : entities) {
            if (!(entity instanceof LivingEntity) || !(this.getDistanceSqXZToEntity(entity) < radiusSq) || this.caster instanceof EntityBarako && entity instanceof LeaderSunstrikeImmune || this.caster instanceof PlayerEntity && entity == this.caster) continue;
            float damageFire = 2.0f;
            float damageMob = 2.0f;
            if (this.caster instanceof EntityBarako) {
                damageFire = (float)((double)damageFire * (Double)ConfigHandler.COMMON.MOBS.BARAKO.combatConfig.attackMultiplier.get());
                damageMob = (float)((double)damageMob * (Double)ConfigHandler.COMMON.MOBS.BARAKO.combatConfig.attackMultiplier.get());
            }
            if (this.caster instanceof PlayerEntity) {
                damageFire = (float)((double)damageFire * (Double)ConfigHandler.COMMON.TOOLS_AND_ABILITIES.SUNS_BLESSING.sunsBlessingAttackMultiplier.get());
                damageMob = (float)((double)damageMob * (Double)ConfigHandler.COMMON.TOOLS_AND_ABILITIES.SUNS_BLESSING.sunsBlessingAttackMultiplier.get());
            }
            if (entity.func_70097_a(DamageSource.func_188403_a((Entity)this, (LivingEntity)this.caster), damageMob)) {
                entity.field_70172_ad = 0;
            }
            if (!entity.func_70097_a(DamageSource.field_76370_b, damageFire)) continue;
            entity.func_70015_d(3);
        }
    }

    public double getDistanceSqXZToEntity(Entity entityIn) {
        double d0 = this.func_226277_ct_() - entityIn.func_226277_ct_();
        double d2 = this.func_226281_cx_() - entityIn.func_226281_cx_();
        return d0 * d0 + d2 * d2;
    }

    private void smolder() {
        if (this.field_70146_Z.nextFloat() < 0.1f) {
            int amount = this.field_70146_Z.nextInt(2) + 1;
            while (amount-- > 0) {
                float theta = this.field_70146_Z.nextFloat() * ((float)Math.PI * 2);
                float r = this.field_70146_Z.nextFloat() * 0.7f;
                float x = r * MathHelper.func_76134_b((float)theta);
                float z = r * MathHelper.func_76126_a((float)theta);
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197594_E, this.func_226277_ct_() + (double)x, this.func_226278_cu_() + 0.1, this.func_226281_cx_() + (double)z, 0.0, 0.0, 0.0);
            }
        }
    }

    private void spawnExplosionParticles(int amount) {
        int i;
        for (i = 0; i < amount; ++i) {
            float velocity = 0.1f;
            float yaw = (float)i * ((float)Math.PI * 2 / (float)amount);
            float vy = this.field_70146_Z.nextFloat() * 0.08f;
            float vx = 0.1f * MathHelper.func_76134_b((float)yaw);
            float vz = 0.1f * MathHelper.func_76126_a((float)yaw);
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197631_x, this.func_226277_ct_(), this.func_226278_cu_() + 0.1, this.func_226281_cx_(), (double)vx, (double)vy, (double)vz);
        }
        for (i = 0; i < amount / 2; ++i) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197595_F, this.func_226277_ct_(), this.func_226278_cu_() + 0.1, this.func_226281_cx_(), 0.0, 0.0, 0.0);
        }
    }

    public void onSummon() {
        this.setVariant(this.field_70146_Z.nextLong());
    }

    private RayTraceResult rayTrace(EntitySunstrike entity) {
        Vector3d startPos = new Vector3d(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
        Vector3d endPos = new Vector3d(entity.func_226277_ct_(), 0.0, entity.func_226281_cx_());
        return entity.field_70170_p.func_217299_a(new RayTraceContext(startPos, endPos, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this));
    }

    public void func_213281_b(CompoundNBT compound) {
        compound.func_74768_a("strikeTime", this.strikeTime);
        compound.func_74772_a("variant", this.getVariant());
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void func_70037_a(CompoundNBT compound) {
        this.setStrikeTime(compound.func_74762_e("strikeTime"));
        this.setVariant(compound.func_74763_f("variant"));
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.writeInt(this.strikeTime);
    }

    public void readSpawnData(PacketBuffer buffer) {
        this.setStrikeTime(buffer.readInt());
    }
}

