/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.world.feature;

import com.bobmowzie.mowziesmobs.MowziesMobs;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.world.feature.structure.BarakoaVillagePieces;
import com.bobmowzie.mowziesmobs.server.world.feature.structure.BarakoaVillageStructure;
import com.bobmowzie.mowziesmobs.server.world.feature.structure.FrostmawPieces;
import com.bobmowzie.mowziesmobs.server.world.feature.structure.FrostmawStructure;
import com.bobmowzie.mowziesmobs.server.world.feature.structure.WroughtnautChamberPieces;
import com.bobmowzie.mowziesmobs.server.world.feature.structure.WroughtnautChamberStructure;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.World;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.FlatChunkGenerator;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class FeatureHandler {
    public static final DeferredRegister<Structure<?>> REG = DeferredRegister.create((IForgeRegistry)ForgeRegistries.STRUCTURE_FEATURES, (String)"mowziesmobs");
    public static RegistryObject<Structure<NoFeatureConfig>> WROUGHTNAUT_CHAMBER = FeatureHandler.registerStructure("wrought_chamber", () -> new WroughtnautChamberStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static IStructurePieceType WROUGHTNAUT_CHAMBER_PIECE = IStructurePieceType.func_214750_a(WroughtnautChamberPieces.Piece::new, (String)"mowziesmobswrought_chamber_template");
    public static RegistryObject<Structure<NoFeatureConfig>> BARAKOA_VILLAGE = FeatureHandler.registerStructure("barakoa_village", () -> new BarakoaVillageStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static IStructurePieceType BARAKOA_VILLAGE_PIECE = IStructurePieceType.func_214750_a(BarakoaVillagePieces.Piece::new, (String)"mowziesmobsbarakoa_village_template");
    public static IStructurePieceType BARAKOA_VILLAGE_HOUSE = IStructurePieceType.func_214750_a(BarakoaVillagePieces.HousePiece::new, (String)"mowziesmobsbarakoa_village_house");
    public static IStructurePieceType BARAKOA_VILLAGE_FIREPIT = IStructurePieceType.func_214750_a(BarakoaVillagePieces.FirepitPiece::new, (String)"mowziesmobsbarakoa_village_firepit");
    public static IStructurePieceType BARAKOA_VILLAGE_STAKE = IStructurePieceType.func_214750_a(BarakoaVillagePieces.StakePiece::new, (String)"mowziesmobsbarakoa_village_stake");
    public static IStructurePieceType BARAKOA_VILLAGE_ALTAR = IStructurePieceType.func_214750_a(BarakoaVillagePieces.AltarPiece::new, (String)"mowziesmobsbarakoa_village_altar");
    public static RegistryObject<Structure<NoFeatureConfig>> FROSTMAW = FeatureHandler.registerStructure("frostmaw_spawn", () -> new FrostmawStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static IStructurePieceType FROSTMAW_PIECE = IStructurePieceType.func_214750_a(FrostmawPieces.Piece::new, (String)"mowziesmobsfrostmaw_template");
    private static Method GETCODEC_METHOD;

    private static <T extends Structure<?>> RegistryObject<T> registerStructure(String name, Supplier<T> structure) {
        return REG.register(name, structure);
    }

    public static void setupStructures() {
        FeatureHandler.setupMapSpacingAndLand((Structure)WROUGHTNAUT_CHAMBER.get(), new StructureSeparationSettings(((Integer)ConfigHandler.COMMON.MOBS.FERROUS_WROUGHTNAUT.generationConfig.generationDistance.get()).intValue(), ((Integer)ConfigHandler.COMMON.MOBS.FERROUS_WROUGHTNAUT.generationConfig.generationSeparation.get()).intValue(), 123555789), false);
        FeatureHandler.setupMapSpacingAndLand((Structure)BARAKOA_VILLAGE.get(), new StructureSeparationSettings(((Integer)ConfigHandler.COMMON.MOBS.BARAKO.generationConfig.generationDistance.get()).intValue(), ((Integer)ConfigHandler.COMMON.MOBS.BARAKO.generationConfig.generationSeparation.get()).intValue(), 123444789), false);
        FeatureHandler.setupMapSpacingAndLand((Structure)FROSTMAW.get(), new StructureSeparationSettings(((Integer)ConfigHandler.COMMON.MOBS.FROSTMAW.generationConfig.generationDistance.get()).intValue(), ((Integer)ConfigHandler.COMMON.MOBS.FROSTMAW.generationConfig.generationSeparation.get()).intValue(), 1237654789), true);
    }

    public static <F extends Structure<?>> void setupMapSpacingAndLand(F structure, StructureSeparationSettings structureSeparationSettings, boolean transformSurroundingLand) {
        Structure.field_236365_a_.put((Object)structure.getRegistryName().toString(), structure);
        if (transformSurroundingLand) {
            Structure.field_236384_t_ = ImmutableList.builder().addAll((Iterable)Structure.field_236384_t_).add(structure).build();
        }
        DimensionStructuresSettings.field_236191_b_ = ImmutableMap.builder().putAll((Map)DimensionStructuresSettings.field_236191_b_).put(structure, (Object)structureSeparationSettings).build();
        WorldGenRegistries.field_243658_j.func_239659_c_().forEach(settings -> {
            Map structureMap = ((DimensionSettings)settings.getValue()).func_236108_a_().func_236195_a_();
            if (structureMap instanceof ImmutableMap) {
                HashMap<Structure, StructureSeparationSettings> tempMap = new HashMap<Structure, StructureSeparationSettings>(structureMap);
                tempMap.put(structure, structureSeparationSettings);
                ((DimensionSettings)settings.getValue()).func_236108_a_().field_236193_d_ = tempMap;
            } else {
                structureMap.put(structure, structureSeparationSettings);
            }
        });
    }

    public static void addDimensionalSpacing(WorldEvent.Load event) {
        if (event.getWorld() instanceof ServerWorld) {
            ServerWorld serverWorld = (ServerWorld)event.getWorld();
            try {
                ResourceLocation cgRL;
                if (GETCODEC_METHOD == null) {
                    GETCODEC_METHOD = ObfuscationReflectionHelper.findMethod(ChunkGenerator.class, (String)"func_230347_a_", (Class[])new Class[0]);
                }
                if ((cgRL = Registry.field_239690_aB_.func_177774_c((Object)((Codec)GETCODEC_METHOD.invoke((Object)serverWorld.func_72863_F().field_186029_c, new Object[0])))) != null && cgRL.func_110624_b().equals("terraforged")) {
                    return;
                }
            }
            catch (Exception e) {
                MowziesMobs.LOGGER.error("Was unable to check if " + serverWorld.func_234923_W_().func_240901_a_() + " is using Terraforged's ChunkGenerator.");
            }
            if (serverWorld.func_72863_F().func_201711_g() instanceof FlatChunkGenerator && serverWorld.func_234923_W_().equals(World.field_234918_g_)) {
                return;
            }
            HashMap tempMap = new HashMap(serverWorld.func_72863_F().field_186029_c.func_235957_b_().func_236195_a_());
            FeatureHandler.addStructureSpacing((Structure<NoFeatureConfig>)((Structure)WROUGHTNAUT_CHAMBER.get()), tempMap, serverWorld, ConfigHandler.COMMON.MOBS.FERROUS_WROUGHTNAUT.generationConfig);
            FeatureHandler.addStructureSpacing((Structure<NoFeatureConfig>)((Structure)BARAKOA_VILLAGE.get()), tempMap, serverWorld, ConfigHandler.COMMON.MOBS.BARAKO.generationConfig);
            FeatureHandler.addStructureSpacing((Structure<NoFeatureConfig>)((Structure)FROSTMAW.get()), tempMap, serverWorld, ConfigHandler.COMMON.MOBS.FROSTMAW.generationConfig);
            serverWorld.func_72863_F().field_186029_c.func_235957_b_().field_236193_d_ = tempMap;
        }
    }

    private static void addStructureSpacing(Structure<NoFeatureConfig> structure, Map<Structure<?>, StructureSeparationSettings> tempMap, ServerWorld world, ConfigHandler.GenerationConfig generationConfig) {
        ResourceLocation currDimensionName;
        List dimensionNames = (List)generationConfig.dimensions.get();
        if (dimensionNames.contains((currDimensionName = world.func_234923_W_().func_240901_a_()).toString())) {
            tempMap.putIfAbsent(structure, (StructureSeparationSettings)DimensionStructuresSettings.field_236191_b_.get(structure));
        } else {
            tempMap.remove(structure);
        }
    }
}

