/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.serialization;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import net.darkhax.bookshelf.serialization.ISerializer;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NumberNBT;
import net.minecraft.network.PacketBuffer;

public final class SerializerFloat
implements ISerializer<Float> {
    public static final ISerializer<Float> SERIALIZER = new SerializerFloat();

    private SerializerFloat() {
    }

    @Override
    public Float read(JsonElement json) {
        return Float.valueOf(json.getAsFloat());
    }

    @Override
    public JsonElement write(Float toWrite) {
        return new JsonPrimitive((Number)toWrite);
    }

    @Override
    public Float read(PacketBuffer buffer) {
        return Float.valueOf(buffer.readFloat());
    }

    @Override
    public void write(PacketBuffer buffer, Float toWrite) {
        buffer.writeFloat(toWrite.floatValue());
    }

    @Override
    public INBT writeNBT(Float toWrite) {
        return FloatNBT.func_229689_a_((float)toWrite.floatValue());
    }

    @Override
    public Float read(INBT nbt) {
        if (nbt instanceof NumberNBT) {
            return Float.valueOf(((NumberNBT)nbt).func_150288_h());
        }
        throw new IllegalArgumentException("Expected NBT to be a number tag. Class was " + nbt.getClass() + " with ID " + nbt.func_74732_a() + " instead.");
    }
}

