/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.minimap;

import com.mojang.blaze3d.matrix.MatrixStack;
import journeymap.client.JourneymapClient;
import journeymap.client.properties.MiniMapProperties;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.minimap.DisplayVars;
import journeymap.client.ui.minimap.Position;
import journeymap.client.ui.minimap.Selectable;
import journeymap.client.ui.theme.ThemeLabelSource;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.util.InputMappings;
import net.minecraft.util.math.vector.Vector2f;

public class Effect
implements Selectable {
    private static Effect INSTANCE;
    private int x;
    private int y;
    private int height;
    private int width;
    private int dragOffsetX = 0;
    private int dragOffsetY = 0;
    private boolean dragging = false;

    public static Effect getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new Effect();
        }
        return INSTANCE;
    }

    public static int[] effectProcessor(int k, int l, int j, int i, net.minecraft.potion.Effect mobEffect) {
        MiniMapProperties prop = JourneymapClient.getInstance().getActiveMiniMapProperties();
        int x = k;
        int y = l;
        if (prop.moveEffectIcons.get().booleanValue()) {
            boolean vertical = prop.effectVertical.get();
            boolean reversed = prop.effectReversed.get();
            x = Minecraft.func_71410_x().func_228018_at_().func_198107_o() - 25;
            y = 1;
            boolean beneficial = mobEffect.func_188408_i();
            int multi = 25 * (beneficial ? j - 1 : i - 1);
            if (vertical) {
                x = beneficial ? x : x - 26;
                y = reversed ? y - multi : y + multi;
            } else if (reversed) {
                y = beneficial ? y : y + 26;
                x += multi;
            } else {
                return new int[]{k, l};
            }
        }
        return new int[]{x, y};
    }

    @Override
    public void renderBorder(MatrixStack stack, int color) {
        MiniMapProperties prop = JourneymapClient.getInstance().getActiveMiniMapProperties();
        MainWindow window = Minecraft.func_71410_x().func_228018_at_();
        boolean vertical = prop.moveEffectIcons.get() != false ? prop.effectVertical.get() : false;
        boolean reversed = prop.moveEffectIcons.get() != false ? prop.effectReversed.get() : false;
        color = prop.moveEffectIcons.get() != false ? color : -65536;
        this.width = vertical ? 51 : 100;
        this.x = reversed && !vertical ? window.func_198107_o() + 75 : window.func_198107_o();
        int endX = this.x - this.width - 2;
        this.height = vertical ? (reversed ? -74 : 102) : 52;
        this.y = reversed && vertical ? 26 : 0;
        Vector2f location = this.getPotionEffectsLocation();
        stack.func_227860_a_();
        stack.func_227861_a_((double)location.field_189982_i, (double)(location.field_189983_j - 1.0f), 0.0);
        int bottomOffset = reversed && vertical ? -1 : 1;
        int topOffset = reversed && vertical ? 2 : 0;
        AbstractGui.func_238467_a_((MatrixStack)stack, (int)this.x, (int)(this.height - 1), (int)(endX + 1), (int)(this.height + 1), (int)color);
        AbstractGui.func_238467_a_((MatrixStack)stack, (int)(this.x - 1), (int)(this.height + bottomOffset), (int)(this.x + 1), (int)(this.y + topOffset), (int)color);
        AbstractGui.func_238467_a_((MatrixStack)stack, (int)this.x, (int)this.y, (int)(endX + 1), (int)(this.y + 2), (int)color);
        AbstractGui.func_238467_a_((MatrixStack)stack, (int)endX, (int)(this.height + bottomOffset), (int)(endX + 2), (int)(this.y + topOffset), (int)color);
        stack.func_227865_b_();
    }

    public boolean withinBounds(double mouseX, double mouseY) {
        int screenWidth = Minecraft.func_71410_x().func_228018_at_().func_198107_o();
        MiniMapProperties prop = JourneymapClient.getInstance().getActiveMiniMapProperties();
        boolean vertical = prop.effectVertical.get();
        boolean reversed = prop.effectReversed.get();
        Vector2f location = this.getPotionEffectsLocation();
        int leftX = (int)((float)screenWidth - ((float)(this.width - 2) - location.field_189982_i));
        int topY = (int)((float)this.y + location.field_189983_j);
        int rightX = (int)((float)screenWidth + location.field_189982_i);
        int bottomY = (int)((float)this.height + location.field_189983_j);
        if (reversed && !vertical) {
            leftX = (int)((float)this.x - ((float)(this.width - 2) - location.field_189982_i));
            rightX = (int)((float)this.x + location.field_189982_i);
        }
        return mouseX < (double)rightX && mouseX > (double)leftX && (reversed && vertical ? mouseY < (double)topY : mouseY > (double)topY) && (reversed && vertical ? mouseY > (double)bottomY : mouseY < (double)bottomY);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int pButton) {
        if (this.withinBounds(mouseX, mouseY) && !this.dragging) {
            MiniMapProperties prop = JourneymapClient.getInstance().getActiveMiniMapProperties();
            int screenWidth = Minecraft.func_71410_x().func_228018_at_().func_198107_o();
            this.dragging = true;
            this.dragOffsetX = (int)(mouseX - (double)(prop.effectTranslateX.get() + screenWidth));
            this.dragOffsetY = (int)(mouseY - (double)prop.effectTranslateY.get().intValue());
            return true;
        }
        this.dragging = false;
        return false;
    }

    @Override
    public boolean mouseDragged(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (this.dragging) {
            int screenWidth = Minecraft.func_71410_x().func_228018_at_().func_198107_o();
            MiniMapProperties prop = JourneymapClient.getInstance().getActiveMiniMapProperties();
            int posX = (int)(pMouseX - (double)this.dragOffsetX) - screenWidth;
            int posY = (int)(pMouseY - (double)this.dragOffsetY);
            Vector2f loc = this.withinScreenBounds(posX, posY);
            prop.effectTranslateX.set((Object)((int)loc.field_189982_i));
            prop.effectTranslateY.set((Object)((int)loc.field_189983_j));
            return true;
        }
        return false;
    }

    public Vector2f withinScreenBounds(double pMouseX, double pMouseY) {
        double y;
        double x;
        int screenHeight = Minecraft.func_71410_x().func_228018_at_().func_198087_p();
        int screenWidth = Minecraft.func_71410_x().func_228018_at_().func_198107_o();
        MiniMapProperties prop = JourneymapClient.getInstance().getActiveMiniMapProperties();
        boolean vertical = prop.effectVertical.get();
        boolean reversed = prop.effectReversed.get();
        double d = pMouseX > 0.0 ? 0.0 : (x = pMouseX - (double)this.width < (double)(-screenWidth) ? (double)(-screenWidth + this.width) : pMouseX);
        double d2 = pMouseY < 0.0 ? 0.0 : (y = pMouseY + (double)this.height > (double)screenHeight ? (double)(screenHeight - this.height) : pMouseY);
        if (reversed && !vertical) {
            x = pMouseX + 75.0 > 0.0 ? -75.0 : (pMouseX - 26.0 < (double)(-screenWidth) ? (double)(-screenWidth + 26) : pMouseX);
        } else if (reversed) {
            y = pMouseY - 75.0 < 0.0 ? 75.0 : (pMouseY + 26.0 > (double)screenHeight ? (double)(screenHeight - 26) : pMouseY);
        }
        return new Vector2f((float)x, (float)y);
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int mouseButton) {
        if (this.dragging) {
            this.dragOffsetX = 0;
            this.dragOffsetY = 0;
            this.dragging = false;
            return true;
        }
        return false;
    }

    @Override
    public void tick() {
        long windowId = Minecraft.func_71410_x().func_228018_at_().func_198092_i();
        int speed = (int)(JourneymapClient.getInstance().getActiveMiniMapProperties().minimapKeyMovementSpeed.get().floatValue() * 1000.0f);
        if (InputMappings.func_216506_a((long)windowId, (int)265)) {
            this.moveOnKey(0, -speed);
        } else if (InputMappings.func_216506_a((long)windowId, (int)264)) {
            this.moveOnKey(0, speed);
        } else if (InputMappings.func_216506_a((long)windowId, (int)263)) {
            this.moveOnKey(-speed, 0);
        } else if (InputMappings.func_216506_a((long)windowId, (int)262)) {
            this.moveOnKey(speed, 0);
        }
    }

    private void moveOnKey(int incX, int incY) {
        MiniMapProperties prop = JourneymapClient.getInstance().getActiveMiniMapProperties();
        int posX = prop.effectTranslateX.get();
        int posY = prop.effectTranslateY.get();
        Vector2f loc = this.withinScreenBounds(posX + incX, posY + incY);
        prop.effectTranslateX.set((Object)((int)loc.field_189982_i));
        prop.effectTranslateY.set((Object)((int)loc.field_189983_j));
    }

    public Vector2f getPotionEffectsLocation() {
        int x = 0;
        int y = 0;
        MainWindow window = Minecraft.func_71410_x().func_228018_at_();
        DisplayVars vars = UIManager.INSTANCE.getMiniMap().getDisplayVars();
        MiniMapProperties prop = JourneymapClient.getInstance().getActiveMiniMapProperties();
        if (this.canPotionShift()) {
            x = prop.effectTranslateX.get();
            y = prop.effectTranslateY.get();
            if (x == 0 && y == 0) {
                x = -(window.func_198107_o() - (int)((double)vars.textureX / window.func_198100_s()));
                prop.effectTranslateX.set((Object)x);
            } else {
                return this.withinScreenBounds(x, y);
            }
        }
        return new Vector2f((float)x, (float)y);
    }

    public boolean canPotionShift() {
        DisplayVars vars = UIManager.INSTANCE.getMiniMap().getDisplayVars();
        MiniMapProperties prop = JourneymapClient.getInstance().getActiveMiniMapProperties();
        return prop.moveEffectIcons.get() != false || Position.Custom.equals(vars.position);
    }

    private boolean inDefaultPotionArea() {
        MainWindow window = Minecraft.func_71410_x().func_228018_at_();
        DisplayVars vars = UIManager.INSTANCE.getMiniMap().getDisplayVars();
        MiniMapProperties miniMapProperties = JourneymapClient.getInstance().getActiveMiniMapProperties();
        int topInfoLabelsHeight = vars.getInfoLabelAreaHeight(Minecraft.func_71410_x().field_71466_p, vars.minimapSpec.labelTop, ThemeLabelSource.values.get(miniMapProperties.info1Label.get()), ThemeLabelSource.values.get(miniMapProperties.info2Label.get()));
        double scale = window.func_198100_s();
        int zoneTop = (int)(50.0 * scale) + 10;
        int zoneRight = window.func_198107_o() - (int)((double)window.func_198107_o() * 0.05 * scale);
        int right = (int)((double)(vars.textureX + vars.minimapWidth) / scale);
        int top = vars.textureY - topInfoLabelsHeight;
        return right > zoneRight && top < zoneTop;
    }
}

