/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.nbt.cache;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Either;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import journeymap.common.nbt.cache.CacheFileStorage;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Unit;
import net.minecraft.util.Util;
import net.minecraft.util.concurrent.DelegatedTaskExecutor;
import net.minecraft.util.concurrent.ITaskExecutor;
import net.minecraft.util.concurrent.ITaskQueue;
import net.minecraft.util.math.ChunkPos;

public class CacheWorker
implements AutoCloseable {
    private final AtomicBoolean shutdownRequested = new AtomicBoolean();
    private final DelegatedTaskExecutor<ITaskQueue.RunnableWithPriority> mailbox;
    private final CacheFileStorage storage;
    private final Map<ChunkPos, PendingStore> pendingWrites = Maps.newLinkedHashMap();

    protected CacheWorker(Path path, boolean async) {
        this.storage = new CacheFileStorage(path, async);
        this.mailbox = new DelegatedTaskExecutor((ITaskQueue)new ITaskQueue.Priority(Priority.values().length), Util.func_240992_g_(), "JM-Cache");
    }

    public CompletableFuture<Void> store(ChunkPos chunkPos, @Nullable CompoundNBT tag) {
        return this.submitTask(() -> {
            PendingStore pendingStore = this.pendingWrites.computeIfAbsent(chunkPos, func -> new PendingStore(tag));
            pendingStore.data = tag;
            return Either.left(pendingStore.result);
        }).thenCompose(Function.identity());
    }

    @Nullable
    public CompoundNBT load(ChunkPos chunkPos) throws IOException {
        CompletableFuture<CompoundNBT> future = this.loadAsync(chunkPos);
        try {
            return future.join();
        }
        catch (CompletionException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }

    protected CompletableFuture<CompoundNBT> loadAsync(ChunkPos chunkPos) {
        return this.submitTask(() -> {
            PendingStore store = this.pendingWrites.get(chunkPos);
            if (store != null) {
                return Either.left((Object)store.data);
            }
            try {
                CompoundNBT compoundtag = this.storage.read(chunkPos);
                return Either.left((Object)compoundtag);
            }
            catch (Exception e) {
                return Either.right((Object)e);
            }
        });
    }

    public CompletableFuture<Void> synchronize(boolean sync) {
        CompletionStage future = this.submitTask(() -> Either.left(CompletableFuture.allOf((CompletableFuture[])this.pendingWrites.values().stream().map(pendingStore -> pendingStore.result).toArray(CompletableFuture[]::new)))).thenCompose(Function.identity());
        return sync ? ((CompletableFuture)future).thenCompose(func -> this.submitTask(() -> {
            try {
                this.storage.flush();
                return Either.left(null);
            }
            catch (Exception e) {
                return Either.right((Object)e);
            }
        })) : ((CompletableFuture)future).thenCompose(func -> this.submitTask(() -> Either.left(null)));
    }

    private <T> CompletableFuture<T> submitTask(Supplier<Either<T, Exception>> supplier) {
        return this.mailbox.func_233528_c_(processorHandle -> new ITaskQueue.RunnableWithPriority(Priority.FOREGROUND.ordinal(), () -> this.lambda$null$10(processorHandle, (Supplier)supplier)));
    }

    private void storePendingChunk() {
        if (!this.pendingWrites.isEmpty()) {
            Iterator<Map.Entry<ChunkPos, PendingStore>> iterator2 = this.pendingWrites.entrySet().iterator();
            Map.Entry<ChunkPos, PendingStore> entry = iterator2.next();
            iterator2.remove();
            this.runStore(entry.getKey(), entry.getValue());
            this.tellStorePending();
        }
    }

    private void tellStorePending() {
        this.mailbox.func_212871_a_((Object)new ITaskQueue.RunnableWithPriority(Priority.BACKGROUND.ordinal(), this::storePendingChunk));
    }

    private void runStore(ChunkPos pos, PendingStore store) {
        try {
            this.storage.write(pos, store.data);
            store.result.complete(null);
        }
        catch (Exception e) {
            store.result.completeExceptionally(e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.shutdownRequested.compareAndSet(false, true)) {
            this.mailbox.func_213141_a(processorHandle -> new ITaskQueue.RunnableWithPriority(Priority.SHUTDOWN.ordinal(), () -> processorHandle.func_212871_a_((Object)Unit.INSTANCE))).join();
            this.mailbox.close();
            try {
                this.storage.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private /* synthetic */ void lambda$null$10(ITaskExecutor processorHandle, Supplier supplier) {
        if (!this.shutdownRequested.get()) {
            processorHandle.func_212871_a_(supplier.get());
        }
        this.tellStorePending();
    }

    static enum Priority {
        FOREGROUND,
        BACKGROUND,
        SHUTDOWN;

    }

    static class PendingStore {
        @Nullable
        CompoundNBT data;
        final CompletableFuture<Void> result = new CompletableFuture();

        public PendingStore(@Nullable CompoundNBT data) {
            this.data = data;
        }
    }
}

