/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.util;

import com.mojang.authlib.GameProfile;
import java.util.function.Function;
import journeymap.client.Constants;
import journeymap.common.Journeymap;
import journeymap.common.helper.DimensionHelper;
import journeymap.common.network.data.model.Location;
import journeymap.common.properties.DimensionProperties;
import journeymap.common.properties.PropertiesManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class JourneyMapTeleport {
    private static final JourneyMapTeleport INSTANCE = new JourneyMapTeleport();

    private JourneyMapTeleport() {
    }

    public static JourneyMapTeleport instance() {
        return INSTANCE;
    }

    public boolean attemptTeleport(Entity entity, Location location) {
        MinecraftServer mcServer = ServerLifecycleHooks.getCurrentServer();
        boolean creative = false;
        boolean cheatMode = false;
        if (entity == null) {
            Journeymap.getLogger().error("Attempted to teleport null entity.");
            return false;
        }
        if (entity instanceof ServerPlayerEntity) {
            creative = ((ServerPlayerEntity)entity).field_71075_bZ.field_75098_d;
            cheatMode = mcServer.func_184103_al().func_152596_g(new GameProfile(entity.func_110124_au(), entity.func_200200_C_().getString()));
            if (mcServer == null) {
                entity.func_145747_a((ITextComponent)Constants.getStringTextComponent("Cannot Find World"), Util.field_240973_b_);
                return false;
            }
            if (this.isTeleportAvailable(entity, location) || creative || cheatMode || Journeymap.isOp((PlayerEntity)((ServerPlayerEntity)entity))) {
                if (!entity.func_70089_S()) {
                    entity.func_145747_a((ITextComponent)Constants.getStringTextComponent("Cannot teleport when dead."), Util.field_240973_b_);
                    return false;
                }
                ServerWorld destinationWorld = mcServer.func_71218_a(DimensionHelper.getWorldKeyForName(location.getDim()));
                if (destinationWorld == null) {
                    for (ServerWorld world : mcServer.func_212370_w()) {
                        if (!location.getDim().equalsIgnoreCase(DimensionHelper.getDimName((World)world)) && !location.getDim().equalsIgnoreCase(DimensionHelper.getDimKeyName((RegistryKey<World>)world.func_234923_W_()))) continue;
                        destinationWorld = world;
                        break;
                    }
                }
                if (destinationWorld == null) {
                    entity.func_145747_a((ITextComponent)Constants.getStringTextComponent("Could not get world for Dimension " + location.getDim()), Util.field_240973_b_);
                    return false;
                }
                return this.teleportEntity(destinationWorld, entity, location);
            }
            entity.func_145747_a((ITextComponent)Constants.getStringTextComponent("Server has disabled JourneyMap teleport usage for your current or destination dimension."), Util.field_240973_b_);
            return false;
        }
        return false;
    }

    private boolean isTeleportAvailable(Entity entity, Location location) {
        DimensionProperties destinationProperty = PropertiesManager.getInstance().getDimProperties(DimensionHelper.getWorldKeyForName(location.getDim()));
        DimensionProperties entityLocationProperty = PropertiesManager.getInstance().getDimProperties(DimensionHelper.getDimension(entity));
        return this.canDimTeleport(destinationProperty) && this.canDimTeleport(entityLocationProperty);
    }

    private boolean canDimTeleport(DimensionProperties properties) {
        if (properties.enabled.get().booleanValue()) {
            return properties.teleportEnabled.get();
        }
        return PropertiesManager.getInstance().getGlobalProperties().teleportEnabled.get();
    }

    private boolean teleportEntity(ServerWorld destinationWorld, Entity player, final Location location) {
        boolean changedWorld;
        ServerWorld startWorld = (ServerWorld)player.field_70170_p;
        boolean bl = changedWorld = startWorld != destinationWorld;
        if (player instanceof ServerPlayerEntity) {
            if (changedWorld) {
                ((ServerPlayerEntity)player).changeDimension(destinationWorld, new ITeleporter(){

                    public Entity placeEntity(Entity entity, ServerWorld currentWorld, ServerWorld destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
                        Entity newPosEntity = repositionEntity.apply(false);
                        newPosEntity.func_70634_a(location.getX(), location.getY() + 1.0, location.getZ());
                        return newPosEntity;
                    }
                });
            } else {
                player.func_70634_a(location.getX(), location.getY(), location.getZ());
            }
        }
        return false;
    }
}

