/*
 * Decompiled with CFR 0.152.
 */
package cursedflames.bountifulbaubles.common.baubleeffect;

import cursedflames.bountifulbaubles.common.item.items.ankhparts.shields.ItemShieldObsidian;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

public class EffectFireResist {
    private static float[] calcFireResist(LivingEntity entity) {
        LazyOptional opt = CuriosApi.getCuriosHelper().getCuriosHandler(entity);
        float damageMulti = 1.0f;
        float damageMultiLava = 1.0f;
        float maxDamageNegate = 0.0f;
        if (opt.isPresent()) {
            int i;
            ICuriosItemHandler handler = (ICuriosItemHandler)opt.orElse(null);
            Map items = handler.getCurios();
            HashSet<UUID> found = new HashSet<UUID>();
            for (ICurioStacksHandler stackHandler : items.values()) {
                int size = stackHandler.getSlots();
                for (i = 0; i < size; ++i) {
                    ItemStack stack = stackHandler.getStacks().getStackInSlot(i);
                    Item item = stack.func_77973_b();
                    if (!(item instanceof IFireResistItem) || found.contains(((IFireResistItem)item).getFireResistUUID(stack))) continue;
                    IFireResistItem fireResist = (IFireResistItem)item;
                    found.add(fireResist.getFireResistUUID(stack));
                    damageMulti *= 1.0f - fireResist.getFireResistance(stack);
                    damageMultiLava *= 1.0f - fireResist.getFireResistanceLava(stack);
                    maxDamageNegate = Math.max(maxDamageNegate, fireResist.getFireResistMaxNegate(stack));
                }
            }
            ItemStack mainHand = entity.func_184614_ca();
            ItemStack offHand = entity.func_184592_cb();
            ItemStack stack = mainHand;
            for (i = 0; i < 2; ++i) {
                if (stack.func_77973_b() instanceof IFireResistItem && !found.contains(((IFireResistItem)stack.func_77973_b()).getFireResistUUID(stack)) && stack.func_77973_b() instanceof ItemShieldObsidian) {
                    IFireResistItem fireResist = (IFireResistItem)stack.func_77973_b();
                    found.add(fireResist.getFireResistUUID(stack));
                    damageMulti *= 1.0f - fireResist.getFireResistance(stack);
                    damageMultiLava *= 1.0f - fireResist.getFireResistanceLava(stack);
                    maxDamageNegate = Math.max(maxDamageNegate, fireResist.getFireResistMaxNegate(stack));
                }
                stack = offHand;
            }
        }
        return new float[]{damageMulti, damageMultiLava, maxDamageNegate};
    }

    public static void onFireDamage(LivingAttackEvent event, LivingEntity entity) {
        float[] fireResist = EffectFireResist.calcFireResist(entity);
        float damageMulti = fireResist[0];
        float damageMultiLava = fireResist[1];
        float maxDamageNegate = fireResist[2];
        if (event.getAmount() <= maxDamageNegate && event.isCancelable()) {
            event.setCanceled(true);
        }
        if (event.getSource().equals(DamageSource.field_76371_c)) {
            damageMulti = damageMultiLava;
        }
        if (damageMulti < 0.999f && damageMulti < 0.001f && event.isCancelable()) {
            event.setCanceled(true);
        }
    }

    public static void onFireDamage(LivingHurtEvent event, LivingEntity entity) {
        float[] fireResist = EffectFireResist.calcFireResist(entity);
        float damageMulti = fireResist[0];
        float damageMultiLava = fireResist[1];
        float maxDamageNegate = fireResist[2];
        if (event.getAmount() <= maxDamageNegate && event.isCancelable()) {
            event.setCanceled(true);
        }
        if (event.getSource().equals(DamageSource.field_76371_c)) {
            damageMulti = damageMultiLava;
        }
        if (damageMulti < 0.999f) {
            if (damageMulti < 0.001f && event.isCancelable()) {
                event.setCanceled(true);
            }
            event.setAmount(event.getAmount() * damageMulti);
        }
    }

    public static interface IFireResistItem {
        public float getFireResistance(ItemStack var1);

        public float getFireResistanceLava(ItemStack var1);

        public float getFireResistMaxNegate(ItemStack var1);

        public UUID getFireResistUUID(ItemStack var1);
    }
}

