/*
 * Decompiled with CFR 0.152.
 */
package cursedflames.bountifulbaubles.common.block.blocks;

import cursedflames.bountifulbaubles.common.BountifulBaubles;
import cursedflames.bountifulbaubles.common.ModCapabilities;
import cursedflames.bountifulbaubles.common.block.BBBlock;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class BlockWaterCandle
extends BBBlock
implements IWaterLoggable {
    public static final double EFFECT_RADIUS_SQUARED = 576.0;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final VoxelShape SCONCE_SHAPE = VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)4.5, (double)0.0, (double)4.5, (double)11.5, (double)1.0, (double)11.5), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)4.5, (double)1.0, (double)3.5, (double)11.5, (double)2.0, (double)4.5), Block.func_208617_a((double)11.5, (double)1.0, (double)4.5, (double)12.5, (double)2.0, (double)11.5), Block.func_208617_a((double)4.5, (double)1.0, (double)11.5, (double)11.5, (double)2.0, (double)12.5), Block.func_208617_a((double)3.5, (double)1.0, (double)4.5, (double)4.5, (double)2.0, (double)11.5), Block.func_208617_a((double)6.5, (double)2.0, (double)1.5, (double)9.5, (double)3.0, (double)3.5)});
    public static final VoxelShape CANDLE_SHAPE = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)6.5, (double)1.0, (double)6.5, (double)9.5, (double)8.0, (double)9.5), (VoxelShape)Block.func_208617_a((double)7.5, (double)8.0, (double)7.5, (double)8.5, (double)10.0, (double)8.5));
    public static final VoxelShape FULL_SHAPE = VoxelShapes.func_197872_a((VoxelShape)SCONCE_SHAPE, (VoxelShape)CANDLE_SHAPE);

    public BlockWaterCandle(String name, AbstractBlock.Properties properties) {
        super(name, properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{WATERLOGGED});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return FULL_SHAPE;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SCONCE_SHAPE;
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return BlockWaterCandle.func_220055_a((IWorldReader)worldIn, (BlockPos)pos.func_177977_b(), (Direction)Direction.UP);
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld worldIn, BlockPos pos, BlockPos facingPos) {
        if (((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(pos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        if (facing == Direction.DOWN && !this.func_196260_a(state, (IWorldReader)worldIn, pos)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return super.func_196271_a(state, facing, state, worldIn, pos, facingPos);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        FluidState ifluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        return (BlockState)super.func_196258_a(context).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.func_206886_c() == Fluids.field_204546_a));
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public void func_220082_b(BlockState state, World world, BlockPos pos, BlockState oldState, boolean moving) {
        if (oldState.func_177230_c() == this) {
            return;
        }
        world.getCapability(ModCapabilities.CANDLE_REGISTRY).ifPresent(reg -> {
            BountifulBaubles.logger.info("adding water candle pos");
            reg.addPos(pos);
        });
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean moving) {
        if (newState.func_177230_c() != this) {
            world.getCapability(ModCapabilities.CANDLE_REGISTRY).ifPresent(reg -> {
                BountifulBaubles.logger.info("removing water candle pos");
                reg.removePos(pos);
            });
        }
        super.func_196243_a(state, world, pos, newState, moving);
    }
}

