/*
 * Decompiled with CFR 0.152.
 */
package cursedflames.bountifulbaubles.common.capability;

import cursedflames.bountifulbaubles.common.wormhole.DebugTarget;
import cursedflames.bountifulbaubles.common.wormhole.IWormholeTarget;
import cursedflames.bountifulbaubles.common.wormhole.PlayerTarget;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class CapabilityWormholePins {
    @CapabilityInject(value=IWormholePins.class)
    public static final Capability<IWormholePins> PIN_CAP = null;

    public static void registerCapability() {
        CapabilityManager.INSTANCE.register(IWormholePins.class, (Capability.IStorage)new Storage(), DefaultImpl::new);
    }

    @SubscribeEvent
    public static void onEntityConstruct(AttachCapabilitiesEvent<Entity> event) {
        if (!(event.getObject() instanceof PlayerEntity)) {
            return;
        }
        event.addCapability(new ResourceLocation("bountifulbaubles", "IWormholePins"), (ICapabilityProvider)new ICapabilitySerializable<CompoundNBT>(){
            IWormholePins inst = (IWormholePins)PIN_CAP.getDefaultInstance();

            public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
                return capability == PIN_CAP ? LazyOptional.of(() -> this.inst).cast() : null;
            }

            public CompoundNBT serializeNBT() {
                return (CompoundNBT)PIN_CAP.getStorage().writeNBT(PIN_CAP, (Object)this.inst, null);
            }

            public void deserializeNBT(CompoundNBT nbt) {
                PIN_CAP.getStorage().readNBT(PIN_CAP, (Object)this.inst, null, (INBT)nbt);
            }
        });
    }

    public static CompoundNBT targetListToNBT(List<IWormholeTarget> targets) {
        CompoundNBT tag = new CompoundNBT();
        int i = 0;
        for (IWormholeTarget target : targets) {
            CompoundNBT targetNBT = target.toNBT();
            if (targetNBT == null) continue;
            tag.func_218657_a(String.valueOf(i++), (INBT)targetNBT);
        }
        return tag;
    }

    public static List<IWormholeTarget> targetListFromNBT(List<IWormholeTarget> targets, CompoundNBT tag) {
        targets.clear();
        int i = 0;
        while (tag.func_74764_b(String.valueOf(i))) {
            CompoundNBT entry = tag.func_74775_l(String.valueOf(i));
            IWormholeTarget target = CapabilityWormholePins.targetFromNBT(entry);
            if (target != null) {
                targets.add(target);
            }
            ++i;
        }
        return targets;
    }

    public static IWormholeTarget targetFromNBT(CompoundNBT tag) {
        String type = tag.func_74779_i("type");
        IWormholeTarget target = null;
        if (type.equals("player")) {
            target = new PlayerTarget();
        } else if (type.equals("debug")) {
            target = new DebugTarget();
        }
        if (target == null) {
            return null;
        }
        target.fromNBT(tag);
        target.setEnabled(tag.func_74764_b("enabled") ? tag.func_74767_n("enabled") : true);
        return target;
    }

    public static class DefaultImpl
    implements IWormholePins {
        List<IWormholeTarget> pinList = new ArrayList<IWormholeTarget>();

        @Override
        public List<IWormholeTarget> getPinList() {
            return this.pinList;
        }
    }

    public static class Storage
    implements Capability.IStorage<IWormholePins> {
        public INBT writeNBT(Capability<IWormholePins> capability, IWormholePins instance, Direction side) {
            List<IWormholeTarget> pins = instance.getPinList();
            return CapabilityWormholePins.targetListToNBT(pins);
        }

        public void readNBT(Capability<IWormholePins> capability, IWormholePins instance, Direction side, INBT nbtBase) {
            if (!(nbtBase instanceof CompoundNBT)) {
                return;
            }
            CapabilityWormholePins.targetListFromNBT(instance.getPinList(), (CompoundNBT)nbtBase);
        }
    }

    public static interface IWormholePins {
        public List<IWormholeTarget> getPinList();
    }
}

