/*
 * Decompiled with CFR 0.152.
 */
package cursedflames.bountifulbaubles.common.item.items;

import cursedflames.bountifulbaubles.common.config.Config;
import cursedflames.bountifulbaubles.common.item.BBItem;
import cursedflames.bountifulbaubles.common.item.ModItems;
import cursedflames.bountifulbaubles.common.item.items.ItemMagicMirror;
import cursedflames.bountifulbaubles.common.misc.DamageSourcePhylactery;
import java.util.UUID;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import top.theillusivec4.curios.api.CuriosApi;

public class ItemBrokenHeart
extends BBItem {
    public static final UUID MODIFIER_UUID = UUID.fromString("554f3929-4193-4ae5-a4da-4b528a89ca32");

    public ItemBrokenHeart(String name, Item.Properties props) {
        super(name, props);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onDamage(LivingDamageEvent event) {
        LivingEntity entity = event.getEntityLiving();
        boolean phylactery = CuriosApi.getCuriosHelper().findEquippedCurio(ModItems.phylactery_charm, entity).isPresent();
        if (!(phylactery || event.getSource() instanceof DamageSourcePhylactery || CuriosApi.getCuriosHelper().findEquippedCurio(ModItems.broken_heart, entity).isPresent())) {
            return;
        }
        float healthAfterDamage = entity.func_110143_aJ() - event.getAmount();
        if (healthAfterDamage >= 1.0f) {
            return;
        }
        double maxHealthDamage = 1.0 - (double)healthAfterDamage;
        if ((double)entity.func_110138_aP() <= maxHealthDamage) {
            return;
        }
        ModifiableAttributeInstance maxHealth = entity.func_110148_a(Attributes.field_233818_a_);
        AttributeModifier modifier = maxHealth.func_111127_a(MODIFIER_UUID);
        double prevMaxHealthDamage = 0.0;
        if (modifier != null) {
            prevMaxHealthDamage = modifier.func_111164_d();
            maxHealth.func_111124_b(modifier);
        }
        modifier = new AttributeModifier(MODIFIER_UUID, "Broken Heart MaxHP drain", prevMaxHealthDamage - maxHealthDamage, AttributeModifier.Operation.ADDITION);
        maxHealth.func_233767_b_(modifier);
        if ((double)event.getAmount() - maxHealthDamage < 0.1) {
            event.setCanceled(true);
        }
        event.setAmount((float)Math.max((double)event.getAmount() - maxHealthDamage, 0.0));
        if (phylactery && entity instanceof PlayerEntity && !(event.getSource() instanceof DamageSourcePhylactery)) {
            ItemMagicMirror.teleportPlayerToSpawn(entity.field_70170_p, (PlayerEntity)entity);
        }
        entity.field_70170_p.func_184148_a(null, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), SoundEvents.field_187602_cF, SoundCategory.PLAYERS, 0.7f, (entity.field_70170_p.field_73012_v.nextFloat() - entity.field_70170_p.field_73012_v.nextFloat()) * 0.1f + 0.8f);
    }

    @SubscribeEvent
    public static void onPlayerWake(PlayerWakeUpEvent event) {
        if (!event.updateWorld() && ((Boolean)Config.BROKEN_HEART_REGEN.get()).booleanValue()) {
            ModifiableAttributeInstance maxHealth;
            AttributeModifier modifier;
            LivingEntity entity = event.getEntityLiving();
            if (!entity.field_70170_p.field_72995_K && (modifier = (maxHealth = entity.func_110148_a(Attributes.field_233818_a_)).func_111127_a(MODIFIER_UUID)) != null) {
                maxHealth.func_111124_b(modifier);
                double gain = (Double)Config.BROKEN_HEART_REGEN_AMOUNT.get();
                double newModifier = modifier.func_111164_d() + gain;
                if (newModifier < 0.0) {
                    modifier = new AttributeModifier(MODIFIER_UUID, "Broken Heart MaxHP drain", newModifier, AttributeModifier.Operation.ADDITION);
                    maxHealth.func_233767_b_(modifier);
                    entity.func_145747_a((ITextComponent)new TranslationTextComponent(ModItems.broken_heart.func_77658_a() + ".partial_heal"), Util.field_240973_b_);
                } else {
                    entity.func_145747_a((ITextComponent)new TranslationTextComponent(ModItems.broken_heart.func_77658_a() + ".full_heal"), Util.field_240973_b_);
                }
            }
        }
    }
}

