/*
 * Decompiled with CFR 0.152.
 */
package cursedflames.bountifulbaubles.common.item.items;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import cursedflames.bountifulbaubles.common.item.BBItem;
import cursedflames.bountifulbaubles.common.network.PacketHandler;
import cursedflames.bountifulbaubles.common.network.PacketUpdateToolCooldown;
import cursedflames.bountifulbaubles.common.util.CuriosUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.network.PacketDistributor;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class ItemGlovesDexterity
extends BBItem {
    private static final ResourceLocation texture = new ResourceLocation("bountifulbaubles", "textures/equipped/gloves_dexterity.png");
    private static final Multimap<Attribute, AttributeModifier> modifiers = HashMultimap.create();
    private static final Map<UUID, Integer> entitiesToReset;

    public ItemGlovesDexterity(String name, Item.Properties props) {
        super(name, props);
    }

    @SubscribeEvent
    public static void onEquipmentChange(LivingEquipmentChangeEvent event) {
        if (event.getSlot() == EquipmentSlotType.MAINHAND) {
            LivingEntity entity = event.getEntityLiving();
            if (!(entity instanceof PlayerEntity)) {
                return;
            }
            PlayerEntity player = (PlayerEntity)entity;
            IDynamicStackHandler stackHandler = CuriosUtil.getItemStacksForSlotType((LivingEntity)player, "hands", false);
            if (stackHandler != null) {
                int size = stackHandler.getSlots();
                for (int i = 0; i < size; ++i) {
                    ItemStack stack = stackHandler.getStackInSlot(i);
                    Item item = stack.func_77973_b();
                    if (!(item instanceof ItemGlovesDexterity)) continue;
                    entitiesToReset.put(player.func_110124_au(), player.field_184617_aD);
                    PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new PacketUpdateToolCooldown(player.field_184617_aD));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        PlayerEntity player = event.player;
        if (event.phase == TickEvent.Phase.END && !player.field_70170_p.field_72995_K) {
            UUID toRemove = null;
            for (Map.Entry<UUID, Integer> pair : entitiesToReset.entrySet()) {
                if (!pair.getKey().equals(player.func_110124_au())) continue;
                toRemove = pair.getKey();
                player.field_184617_aD = pair.getValue();
                break;
            }
            if (toRemove != null) {
                entitiesToReset.remove(toRemove);
            }
        }
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT nbt) {
        Curio curio = new Curio(stack);
        return CuriosUtil.makeSimpleCap(curio);
    }

    static {
        modifiers.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(UUID.fromString("f10e9f23-cdff-45d4-94c9-46d5ea53eac8"), "gloves_dexterity attack speed", 0.6, AttributeModifier.Operation.ADDITION));
        entitiesToReset = new HashMap<UUID, Integer>();
    }

    protected static class Curio
    implements ICurio {
        ItemStack stack;

        protected Curio(ItemStack stack) {
            this.stack = stack;
        }

        public Multimap<Attribute, AttributeModifier> getAttributeModifiers(String identifier) {
            return modifiers;
        }
    }
}

