/*
 * Decompiled with CFR 0.152.
 */
package cursedflames.bountifulbaubles.common.item.items;

import cursedflames.bountifulbaubles.common.item.BBItem;
import java.util.Optional;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShearsItem;
import net.minecraft.item.ToolItem;
import net.minecraft.potion.EffectUtils;
import net.minecraft.potion.Effects;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import top.theillusivec4.curios.api.CuriosApi;

public class ItemGlovesDigging
extends BBItem {
    protected IItemTier tier;

    public ItemGlovesDigging(String name, Item.Properties props, IItemTier tier) {
        super(name, props.func_200915_b(tier.func_200926_a()));
        this.tier = tier;
    }

    public int getItemEnchantability(ItemStack stack) {
        return this.tier.func_200927_e();
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return this.tier.func_200924_f().test(repair) || super.func_82789_a(toRepair, repair);
    }

    private boolean canHarvest(BlockState block) {
        return this.tier.func_200925_d() >= block.getHarvestLevel();
    }

    public boolean func_150897_b(BlockState block) {
        return this.canHarvest(block);
    }

    private static boolean isTool(ItemStack stack, BlockState state) {
        Item item;
        return !stack.func_190926_b() && ((item = stack.func_77973_b()) instanceof ToolItem || item instanceof ShearsItem || item instanceof ItemGlovesDigging || item.func_150893_a(stack, state) > 1.0f);
    }

    @SubscribeEvent
    public static void playerHarvestCheck(PlayerEvent.HarvestCheck event) {
        if (event.canHarvest()) {
            return;
        }
        LivingEntity entity = event.getEntityLiving();
        Optional opt = CuriosApi.getCuriosHelper().findEquippedCurio(stack -> stack.func_77973_b() instanceof ItemGlovesDigging, entity);
        if (!opt.isPresent()) {
            return;
        }
        ItemStack stack2 = (ItemStack)((ImmutableTriple)opt.get()).getRight();
        Item item = stack2.func_77973_b();
        if (!(item instanceof ItemGlovesDigging)) {
            return;
        }
        ItemGlovesDigging glove = (ItemGlovesDigging)item;
        ItemStack handitemstack = entity.func_184614_ca();
        if (ItemGlovesDigging.isTool(handitemstack, event.getTargetBlock())) {
            return;
        }
        boolean canHarvest = glove.canHarvest(event.getTargetBlock());
        if (canHarvest) {
            event.setCanHarvest(canHarvest);
        }
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        return this.tier.func_200928_b();
    }

    private float getBreakSpeed(ItemStack stack, LivingEntity entity) {
        float breakspeed = this.tier.func_200928_b();
        int effLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185305_q, (ItemStack)stack);
        if (effLevel > 0) {
            breakspeed += ((float)(effLevel * effLevel) + 1.0f) * 0.4f;
        }
        if (EffectUtils.func_205135_a((LivingEntity)entity)) {
            breakspeed *= 1.0f + (float)(EffectUtils.func_205134_b((LivingEntity)entity) + 1) * 0.2f;
        }
        if (entity.func_70644_a(Effects.field_76419_f)) {
            int level = entity.func_70660_b(Effects.field_76419_f).func_76458_c();
            breakspeed *= level == 0 ? 0.3f : (level == 1 ? 0.09f : (level == 2 ? 0.0027f : 8.1E-4f));
        }
        if (entity.func_208600_a((ITag)FluidTags.field_206959_a) && !EnchantmentHelper.func_185287_i((LivingEntity)entity)) {
            breakspeed /= 5.0f;
        }
        if (!entity.func_233570_aj_()) {
            breakspeed /= 5.0f;
        }
        return breakspeed;
    }

    @SubscribeEvent
    public static void breakSpeed(PlayerEvent.BreakSpeed event) {
        boolean usingGlove;
        LivingEntity entity = event.getEntityLiving();
        Optional opt = CuriosApi.getCuriosHelper().findEquippedCurio(stack -> stack.func_77973_b() instanceof ItemGlovesDigging, entity);
        if (!opt.isPresent()) {
            return;
        }
        ItemStack stack2 = (ItemStack)((ImmutableTriple)opt.get()).getRight();
        Item item = stack2.func_77973_b();
        if (!(item instanceof ItemGlovesDigging)) {
            return;
        }
        ItemGlovesDigging glove = (ItemGlovesDigging)item;
        ItemStack handitemstack = entity.func_184614_ca();
        boolean bl = usingGlove = !ItemGlovesDigging.isTool(handitemstack, event.getState());
        if (!handitemstack.func_190926_b() && handitemstack.func_77973_b() instanceof ItemGlovesDigging) {
            return;
        }
        if (usingGlove) {
            float breakspeed = glove.getBreakSpeed(stack2, entity);
            if (breakspeed > event.getNewSpeed()) {
                event.setNewSpeed(breakspeed);
            }
        } else {
            event.setNewSpeed(event.getNewSpeed() * 0.85f);
        }
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, BlockState state, BlockPos pos, LivingEntity entity) {
        if (!worldIn.field_72995_K && state.func_185887_b((IBlockReader)worldIn, pos) != 0.0f) {
            stack.func_222118_a(1, entity, e -> e.func_213361_c(EquipmentSlotType.MAINHAND));
        }
        return true;
    }

    @SubscribeEvent
    public static void onBreak(BlockEvent.BreakEvent event) {
        float digRate;
        PlayerEntity entity = event.getPlayer();
        if (entity instanceof FakePlayer) {
            return;
        }
        ItemStack handitemstack = entity.func_184614_ca();
        if (ItemGlovesDigging.isTool(handitemstack, event.getState())) {
            return;
        }
        Optional opt = CuriosApi.getCuriosHelper().findEquippedCurio(stack -> stack.func_77973_b() instanceof ItemGlovesDigging, (LivingEntity)entity);
        if (!opt.isPresent()) {
            return;
        }
        ImmutableTriple curio = (ImmutableTriple)opt.get();
        ItemStack stack2 = (ItemStack)curio.getRight();
        Item item = stack2.func_77973_b();
        if (!(item instanceof ItemGlovesDigging)) {
            return;
        }
        ItemGlovesDigging glove = (ItemGlovesDigging)item;
        float breakSpeed = glove.getBreakSpeed(stack2, (LivingEntity)entity);
        float hardness = event.getState().func_185887_b((IBlockReader)entity.field_70170_p, event.getPos());
        int digModifier = glove.canHarvest(event.getState()) ? 30 : 100;
        float f = digRate = hardness == 0.0f ? 10.0f : breakSpeed / hardness / (float)digModifier;
        if (digRate >= 1.0f) {
            entity.func_71020_j(0.005f);
        } else {
            entity.func_71020_j(0.02f);
        }
        if (hardness != 0.0f) {
            stack2.func_222118_a(1, (LivingEntity)entity, e -> CuriosApi.getCuriosHelper().onBrokenCurio((String)curio.getLeft(), ((Integer)curio.getMiddle()).intValue(), (LivingEntity)e));
        }
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchant) {
        if (super.canApplyAtEnchantingTable(stack, enchant)) {
            return true;
        }
        return enchant == Enchantments.field_185307_s || enchant == Enchantments.field_185296_A || enchant == Enchantments.field_190941_k || enchant == Enchantments.field_190940_C || enchant == Enchantments.field_185305_q;
    }
}

