/*
 * Decompiled with CFR 0.152.
 */
package cursedflames.bountifulbaubles.common.item.items.ankhparts.shields;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.blaze3d.matrix.MatrixStack;
import cursedflames.bountifulbaubles.common.util.CuriosUtil;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ShieldItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class ItemShieldCobalt
extends ShieldItem {
    public static final UUID KNOCKBACK_RESISTANCE_UUID = UUID.fromString("418ed1da-15ae-4c7b-ac5e-4807ca52ffe3");
    public static final UUID KNOCKBACK_RESISTANCE_BAUBLE_UUID = UUID.fromString("9016ba1d-70dd-46c4-b0b4-fc4ea39886c1");

    public ItemShieldCobalt(String name, Item.Properties props) {
        super(props);
        this.setRegistryName(new ResourceLocation("bountifulbaubles", name));
    }

    public static boolean isUsable(ItemStack stack) {
        return stack.func_77952_i() < stack.func_77958_k() - 1;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        if (ItemShieldCobalt.isUsable(itemstack)) {
            playerIn.func_184598_c(handIn);
            return ActionResult.func_226249_b_((Object)itemstack);
        }
        return ActionResult.func_226251_d_((Object)itemstack);
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return repair.func_77973_b() == Items.field_151042_j;
    }

    @SubscribeEvent
    public static void onLivingAttack(LivingAttackEvent event) {
        if (!(event.getEntityLiving() instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)event.getEntityLiving();
        if (player.func_184607_cu() == null) {
            return;
        }
        ItemStack stack = player.func_184607_cu();
        float damage = event.getAmount();
        if (!player.field_70170_p.field_72995_K && damage > 3.0f && stack != null && stack.func_77973_b() instanceof ItemShieldCobalt) {
            int i = Math.min(1 + (int)damage, stack.func_77958_k() - stack.func_77952_i() - 1);
            stack.func_222118_a(i, (LivingEntity)player, entity -> {});
            if (stack.func_190926_b() || stack.func_77952_i() >= stack.func_77958_k() - 1) {
                if (stack.func_190926_b()) {
                    Hand enumhand = player.func_184600_cs();
                    ForgeEventFactory.onPlayerDestroyItem((PlayerEntity)player, (ItemStack)stack, (Hand)enumhand);
                    if (enumhand == Hand.MAIN_HAND) {
                        player.func_184201_a(EquipmentSlotType.MAINHAND, ItemStack.field_190927_a);
                    } else {
                        player.func_184201_a(EquipmentSlotType.OFFHAND, ItemStack.field_190927_a);
                    }
                    stack = null;
                }
                player.field_70170_p.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187769_eM, SoundCategory.PLAYERS, 0.9f, 0.8f + player.field_70170_p.field_73012_v.nextFloat() * 0.4f);
            }
        }
    }

    @SubscribeEvent
    public static void onAnvilUpdate(AnvilUpdateEvent event) {
        ItemShieldCobalt.resetRepairValue(event.getLeft());
        ItemShieldCobalt.resetRepairValue(event.getRight());
    }

    @SubscribeEvent
    public static void onAnvilUpdate(AnvilRepairEvent event) {
        ItemShieldCobalt.resetRepairValue(event.getItemResult());
    }

    private static void resetRepairValue(ItemStack stack) {
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemShieldCobalt && stack.func_77942_o()) {
            stack.func_77978_p().func_82580_o("RepairCost");
            ItemShieldCobalt.setHideFlag(stack);
        }
    }

    public String func_77667_c(ItemStack stack) {
        return this.func_77658_a();
    }

    private static void setHideFlag(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new CompoundNBT());
        }
        if (!stack.func_77978_p().func_74764_b("HideFlags")) {
            stack.func_77978_p().func_74768_a("HideFlags", 2);
        }
    }

    public void func_77622_d(ItemStack stack, World worldIn, PlayerEntity playerIn) {
        super.func_77622_d(stack, worldIn, playerIn);
        ItemShieldCobalt.setHideFlag(stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        ItemShieldCobalt.setHideFlag(stack);
        if (stack.func_77952_i() >= stack.func_77958_k()) {
            tooltip.add((ITextComponent)new TranslationTextComponent("bountifulbaubles.broken"));
        }
        tooltip.add((ITextComponent)new TranslationTextComponent(this.func_77658_a() + ".tooltip.0"));
        if (Screen.func_231173_s_()) {
            tooltip.add((ITextComponent)new TranslationTextComponent(this.func_77658_a() + ".tooltip.1"));
            tooltip.add((ITextComponent)new TranslationTextComponent(this.func_77658_a() + ".tooltip.2"));
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("bountifulbaubles.moreinfo"));
        }
    }

    public Multimap<Attribute, AttributeModifier> func_111205_h(EquipmentSlotType slot) {
        HashMultimap mods = HashMultimap.create();
        if (slot == EquipmentSlotType.MAINHAND || slot == EquipmentSlotType.OFFHAND) {
            Attribute knockback = Attributes.field_233820_c_;
            mods.put((Object)knockback, (Object)new AttributeModifier(KNOCKBACK_RESISTANCE_UUID, "Cobalt Shield knockback resistance", 10.0, AttributeModifier.Operation.ADDITION));
        }
        return mods;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT nbt) {
        Curio curio = new Curio(stack);
        return CuriosUtil.makeSimpleCap(curio);
    }

    protected static class Curio
    implements ICurio {
        ItemStack stack;

        protected Curio(ItemStack stack) {
            this.stack = stack;
        }

        public Multimap<Attribute, AttributeModifier> getAttributeModifiers(String identifier) {
            HashMultimap mods = HashMultimap.create();
            Attribute knockback = Attributes.field_233820_c_;
            mods.put((Object)knockback, (Object)new AttributeModifier(KNOCKBACK_RESISTANCE_BAUBLE_UUID, "Cobalt Shield knockback resistance", 10.0, AttributeModifier.Operation.ADDITION));
            return mods;
        }

        public boolean canRender(String identifier, int index, LivingEntity livingEntity) {
            return true;
        }

        public void render(String identifier, int index, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int light, LivingEntity livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            ICurio.RenderHelper.translateIfSneaking((MatrixStack)matrixStack, (LivingEntity)livingEntity);
            ICurio.RenderHelper.rotateIfSneaking((MatrixStack)matrixStack, (LivingEntity)livingEntity);
            boolean armor = !livingEntity.func_184582_a(EquipmentSlotType.CHEST).func_190926_b();
            matrixStack.func_227860_a_();
            matrixStack.func_227862_a_(0.6f, 0.6f, 0.6f);
            matrixStack.func_227863_a_(new Quaternion(0.0f, 0.0f, 1.0f, 0.0f));
            matrixStack.func_227861_a_(0.5, -0.25, armor ? 0.75 : (double)0.7f);
            Minecraft.func_71410_x().func_175599_af().func_229110_a_(this.stack, ItemCameraTransforms.TransformType.NONE, light, OverlayTexture.field_229196_a_, matrixStack, renderTypeBuffer);
            matrixStack.func_227865_b_();
        }
    }
}

