/*
 * Decompiled with CFR 0.152.
 */
package cursedflames.bountifulbaubles.common.util;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class CuriosUtil {
    public static ICapabilityProvider makeSimpleCap(final ICurio curio) {
        ICapabilityProvider provider = new ICapabilityProvider(){
            private final LazyOptional<ICurio> curioOpt = LazyOptional.of(() -> curio);

            public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
                return CuriosCapability.ITEM.orEmpty(cap, this.curioOpt);
            }
        };
        return provider;
    }

    @Nullable
    public static ICurioStacksHandler getCurioStacksHandler(LivingEntity entity, String identifier) {
        LazyOptional opt = CuriosApi.getCuriosHelper().getCuriosHandler(entity);
        if (!opt.isPresent()) {
            return null;
        }
        Optional opt2 = ((ICuriosItemHandler)opt.orElse(null)).getStacksHandler(identifier);
        return (ICurioStacksHandler)opt2.get();
    }

    @Nullable
    public static IDynamicStackHandler getItemStacksForSlotType(LivingEntity entity, String identifier, boolean isCosmetic) {
        LazyOptional opt = CuriosApi.getCuriosHelper().getCuriosHandler(entity);
        if (!opt.isPresent()) {
            return null;
        }
        Optional opt2 = ((ICuriosItemHandler)opt.orElse(null)).getStacksHandler(identifier);
        if (!opt2.isPresent()) {
            return null;
        }
        if (isCosmetic) {
            return ((ICurioStacksHandler)opt2.get()).getCosmeticStacks();
        }
        return ((ICurioStacksHandler)opt2.get()).getStacks();
    }

    @Nullable
    public static ItemStack getItemStackInSlot(LivingEntity entity, String identifier, int index, boolean isCosmetic) {
        IDynamicStackHandler stackHandler = CuriosUtil.getItemStacksForSlotType(entity, identifier, isCosmetic);
        if (stackHandler == null) {
            return null;
        }
        return stackHandler.getStackInSlot(index);
    }
}

