/*
 * Decompiled with CFR 0.152.
 */
package cursedflames.bountifulbaubles.common.watercandle;

import cursedflames.bountifulbaubles.common.BountifulBaubles;
import cursedflames.bountifulbaubles.common.ModCapabilities;
import cursedflames.bountifulbaubles.common.watercandle.WaterCandleRegistryCapability;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.monster.IMob;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;

public class WaterCandleHandler {
    @SubscribeEvent
    public static void onSpawn(LivingSpawnEvent.SpecialSpawn event) {
        SpawnReason reason = event.getSpawnReason();
        if (reason != SpawnReason.NATURAL) {
            return;
        }
        LivingEntity entity = event.getEntityLiving();
        if (!(entity instanceof IMob)) {
            return;
        }
        entity.field_70170_p.getCapability(ModCapabilities.CANDLE_REGISTRY).ifPresent(reg -> {
            Set<BlockPos> poses = reg.getCandlePos((Entity)entity);
            if (poses.isEmpty()) {
                return;
            }
            for (int i = entity.field_70170_p.field_73012_v.nextInt(5); i >= 0; --i) {
                reg.addEntityToSpawn(entity.func_200600_R(), new BlockPos(entity.func_213303_ch()));
            }
        });
    }

    @SubscribeEvent
    public static void onWorldAttachCapabilityEvent(AttachCapabilitiesEvent<World> event) {
        event.addCapability(new ResourceLocation("bountifulbaubles", "watercandle_registry"), (ICapabilityProvider)new WaterCandleRegistryCapability());
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.side == LogicalSide.CLIENT) {
            return;
        }
        if (event.phase == TickEvent.Phase.END) {
            if (BountifulBaubles.server == null) {
                return;
            }
            for (ServerWorld world : BountifulBaubles.server.func_212370_w()) {
                world.getCapability(ModCapabilities.CANDLE_REGISTRY).ifPresent(reg -> reg.onServerTick((World)world));
            }
        }
    }
}

