/*
 * Decompiled with CFR 0.152.
 */
package cursedflames.bountifulbaubles.common.watercandle;

import cursedflames.bountifulbaubles.common.ModCapabilities;
import cursedflames.bountifulbaubles.common.block.ModBlocks;
import cursedflames.bountifulbaubles.common.watercandle.ICandleRegistry;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Callable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class WaterCandleRegistryCapability
implements ICapabilityProvider,
ICapabilitySerializable<CompoundNBT> {
    private ICandleRegistry container = new RegistryContainer();
    private LazyOptional optional = LazyOptional.of(() -> this.container);

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ModCapabilities.CANDLE_REGISTRY) {
            return this.optional;
        }
        return LazyOptional.empty();
    }

    public CompoundNBT serializeNBT() {
        return (CompoundNBT)this.container.serializeNBT();
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.container.deserializeNBT((INBT)nbt);
    }

    public static Callable<ICandleRegistry> getFactory() {
        return () -> new RegistryContainer();
    }

    private static class RegistryContainer
    implements ICandleRegistry {
        private HashSet<BlockPos> positions = new HashSet();
        private int ticksSinceLastCleanup = 0;
        private HashSet<EntitySpawn> spawnTries = new HashSet();

        private RegistryContainer() {
        }

        public CompoundNBT serializeNBT() {
            CompoundNBT tag = new CompoundNBT();
            ListNBT list = new ListNBT();
            for (BlockPos pos : this.positions) {
                list.add((Object)IntNBT.func_229692_a_((int)pos.func_177958_n()));
                list.add((Object)IntNBT.func_229692_a_((int)pos.func_177956_o()));
                list.add((Object)IntNBT.func_229692_a_((int)pos.func_177952_p()));
            }
            tag.func_218657_a("candles", (INBT)list);
            return tag;
        }

        public void deserializeNBT(CompoundNBT nbt) {
            ListNBT list = nbt.func_150295_c("candles", 3);
            int i = 0;
            while (i + 2 < list.size()) {
                BlockPos pos = new BlockPos(list.func_186858_c(i), list.func_186858_c(i + 1), list.func_186858_c(i + 2));
                this.positions.add(pos);
                i += 3;
            }
        }

        @Override
        public Set<BlockPos> getCandlePos(Entity entity) {
            double x = entity.func_226277_ct_();
            double y = entity.func_226278_cu_();
            double z = entity.func_226281_cx_();
            HashSet<BlockPos> poses = new HashSet<BlockPos>();
            for (BlockPos pos : this.positions) {
                double zOff;
                double yOff;
                double xOff = (double)pos.func_177958_n() - x;
                double distSq = xOff * xOff + (yOff = (double)pos.func_177956_o() - y) * yOff + (zOff = (double)pos.func_177952_p() - z) * zOff;
                if (!(distSq < 576.0)) continue;
                poses.add(pos);
            }
            return poses;
        }

        @Override
        public void addPos(BlockPos pos) {
            this.positions.add(pos);
        }

        @Override
        public void removePos(BlockPos pos) {
            this.positions.remove(pos);
        }

        @Override
        public void addEntityToSpawn(EntityType<?> entityType, BlockPos pos) {
            this.spawnTries.add(new EntitySpawn(entityType, pos));
        }

        @Override
        public void onServerTick(World world) {
            HashSet<EntitySpawn> spawnTriesToRemove = new HashSet<EntitySpawn>();
            for (EntitySpawn ent : this.spawnTries) {
                int horRange = 9 + ent.numAttempts;
                int verRange = 3 + ent.numAttempts / 3;
                BlockPos tryPos = ent.pos.func_177982_a(world.field_73012_v.nextInt(horRange * 2 + 1) - horRange, world.field_73012_v.nextInt(verRange * 2 + 1) - verRange, world.field_73012_v.nextInt(horRange * 2 + 1) - horRange);
                if (world.func_226664_a_(ent.type.func_220328_a((double)tryPos.func_177958_n(), (double)tryPos.func_177956_o(), (double)tryPos.func_177952_p())) && EntitySpawnPlacementRegistry.func_223515_a(ent.type, (IServerWorld)((ServerWorld)world), (SpawnReason)SpawnReason.SPAWNER, (BlockPos)tryPos, (Random)world.field_73012_v)) {
                    Entity entity = ent.type.func_220331_a((ServerWorld)world, null, null, tryPos, SpawnReason.SPAWNER, false, false);
                    spawnTriesToRemove.add(ent);
                    continue;
                }
                ++ent.numAttempts;
                if (ent.numAttempts <= 20) continue;
                spawnTriesToRemove.add(ent);
            }
            for (EntitySpawn rem : spawnTriesToRemove) {
                this.spawnTries.remove(rem);
            }
            ++this.ticksSinceLastCleanup;
            if (this.ticksSinceLastCleanup < 200) {
                return;
            }
            this.ticksSinceLastCleanup = 0;
            HashSet<BlockPos> toRemove = new HashSet<BlockPos>();
            for (BlockPos pos : this.positions) {
                BlockState state;
                if (!world.isAreaLoaded(pos, 1) || (state = world.func_180495_p(pos)).func_177230_c() == ModBlocks.water_candle) continue;
                toRemove.add(pos);
            }
            for (BlockPos pos : toRemove) {
                this.positions.remove(pos);
            }
        }

        private static class EntitySpawn {
            public final EntityType<?> type;
            public final BlockPos pos;
            public int numAttempts = 0;

            public EntitySpawn(EntityType<?> type, BlockPos pos) {
                this.type = type;
                this.pos = pos;
            }
        }
    }
}

