/*
 * Decompiled with CFR 0.152.
 */
package cursedflames.bountifulbaubles.common.wormhole;

import com.google.common.collect.Lists;
import cursedflames.bountifulbaubles.common.capability.CapabilityWormholePins;
import cursedflames.bountifulbaubles.common.network.PacketHandler;
import cursedflames.bountifulbaubles.common.network.wormhole.SPacketUpdateWormholeGui;
import cursedflames.bountifulbaubles.common.wormhole.IWormholeTarget;
import cursedflames.bountifulbaubles.common.wormhole.PlayerTarget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.registries.ObjectHolder;

public class ContainerWormhole
extends Container {
    @ObjectHolder(value="bountifulbaubles:wormhole")
    public static ContainerType<ContainerWormhole> CONTAINER_REFORGE;
    public PlayerEntity player;
    public List<IWormholeTarget> targets = new ArrayList<IWormholeTarget>();
    public int pinCount = 0;
    public boolean dirty = false;
    public boolean guiDirty = false;
    protected final List<IContainerListener> field_75149_d = Lists.newArrayList();

    public ContainerWormhole(int windowId, PlayerEntity player) {
        super(CONTAINER_REFORGE, windowId);
        IWormholeTarget target;
        int i;
        this.player = player;
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        List<Object> pinned = new ArrayList();
        LazyOptional cap = player.getCapability(CapabilityWormholePins.PIN_CAP, null);
        if (cap.isPresent()) {
            pinned = ((CapabilityWormholePins.IWormholePins)cap.orElse(null)).getPinList();
        }
        HashMap<Integer, IWormholeTarget> pinnedFound = new HashMap<Integer, IWormholeTarget>();
        ArrayList players = new ArrayList(player.field_70170_p.func_217369_A());
        players.remove(player);
        boolean survivalOnly = !player.func_184812_l_() && !player.func_175149_v();
        for (PlayerEntity entity : players) {
            if (entity.func_175149_v() || survivalOnly && entity.func_184812_l_()) continue;
            this.targets.add(new PlayerTarget(entity));
        }
        block1: for (i = 0; i < this.targets.size(); ++i) {
            target = this.targets.get(i);
            for (int j = 0; j < pinned.size(); ++j) {
                IWormholeTarget other = (IWormholeTarget)pinned.get(j);
                if (!target.isEqual(other)) continue;
                pinnedFound.put(j, target);
                this.targets.remove(i);
                --i;
                continue block1;
            }
        }
        for (i = pinned.size() - 1; i >= 0; --i) {
            if (pinnedFound.containsKey(i)) {
                target = (IWormholeTarget)pinnedFound.get(i);
            } else {
                target = (IWormholeTarget)pinned.get(i);
                target.setEnabled(false);
            }
            this.targets.add(0, target);
        }
        this.pinCount = pinned.size();
        this.dirty = true;
    }

    public boolean func_75145_c(PlayerEntity player) {
        return player == this.player;
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (this.player.field_70170_p.field_72995_K || !this.dirty) {
            return;
        }
        CompoundNBT changes = new CompoundNBT();
        CompoundNBT targetsNBT = new CompoundNBT();
        int i = 0;
        for (IWormholeTarget target : this.targets) {
            CompoundNBT targetNBT = target.toNBT();
            if (targetNBT == null) continue;
            targetNBT.func_74757_a("enabled", target.isEnabled());
            targetsNBT.func_218657_a(String.valueOf(i++), (INBT)targetNBT);
        }
        changes.func_218657_a("targets", (INBT)targetsNBT);
        changes.func_74768_a("pinCount", this.pinCount);
        for (int j = 0; j < this.field_75149_d.size(); ++j) {
            IContainerListener listener = this.field_75149_d.get(j);
            if (!(listener instanceof ServerPlayerEntity)) continue;
            ServerPlayerEntity player = (ServerPlayerEntity)listener;
            PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SPacketUpdateWormholeGui(changes));
        }
        this.dirty = false;
    }

    public void readChanges(CompoundNBT tag) {
        CompoundNBT targetsNBT = tag.func_74775_l("targets");
        if (targetsNBT.func_186856_d() > 0) {
            this.targets.clear();
            CapabilityWormholePins.targetListFromNBT(this.targets, targetsNBT);
            this.guiDirty = true;
        }
        if (tag.func_74764_b("pinCount")) {
            this.pinCount = tag.func_74762_e("pinCount");
        }
    }

    public void pin(int index) {
        if (index < 0 || index > this.targets.size() - 1) {
            return;
        }
        IWormholeTarget target = this.targets.get(index);
        if (index < this.pinCount) {
            --this.pinCount;
            this.targets.add(this.pinCount + 1, target);
            this.targets.remove(index);
        } else {
            ++this.pinCount;
            this.targets.remove(index);
            this.targets.add(this.pinCount - 1, target);
        }
        this.dirty = true;
        this.func_75142_b();
    }

    public void func_75132_a(IContainerListener listener) {
        super.func_75132_a(listener);
        if (!this.field_75149_d.contains(listener)) {
            this.field_75149_d.add(listener);
            this.dirty = true;
            this.func_75142_b();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_82847_b(IContainerListener listener) {
        this.field_75149_d.remove(listener);
        super.func_82847_b(listener);
    }
}

