/*
 * Decompiled with CFR 0.152.
 */
package cursedflames.bountifulbaubles.common.wormhole;

import cursedflames.bountifulbaubles.common.wormhole.IWormholeTarget;
import cursedflames.bountifulbaubles.common.wormhole.WormholeUtil;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.world.World;

public class PlayerTarget
implements IWormholeTarget {
    public UUID id;
    public String name = "";
    public boolean enabled = true;

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public PlayerTarget(PlayerEntity player) {
        this.id = player.func_110124_au();
        this.name = player.func_200200_C_().getString();
    }

    public PlayerTarget(UUID id) {
        this.id = id;
    }

    public PlayerTarget() {
    }

    @Override
    public String getName() {
        return this.name.length() > 0 ? this.name : this.id.toString();
    }

    public PlayerEntity getPlayer(World world) {
        List players = world.func_217369_A();
        for (PlayerEntity other : players) {
            if (!other.func_110124_au().equals(this.id)) continue;
            return other;
        }
        return null;
    }

    @Override
    public boolean teleportPlayerTo(PlayerEntity player) {
        PlayerEntity other = this.getPlayer(player.field_70170_p);
        if (other == null) {
            return false;
        }
        WormholeUtil.doTeleport(player, other);
        return true;
    }

    @Override
    public CompoundNBT toNBT() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74778_a("type", "player");
        tag.func_186854_a("id", this.id);
        tag.func_74778_a("name", this.name);
        return tag;
    }

    @Override
    public void fromNBT(CompoundNBT tag) {
        if (!tag.func_186855_b("id")) {
            return;
        }
        this.id = tag.func_186857_a("id");
        this.name = tag.func_74779_i("name");
    }

    @Override
    public boolean isEqual(IWormholeTarget other) {
        return other instanceof PlayerTarget && this.id.equals(((PlayerTarget)other).id);
    }
}

