/*
 * Decompiled with CFR 0.152.
 */
package cursedflames.bountifulbaubles.common.wormhole;

import cursedflames.bountifulbaubles.common.network.PacketHandler;
import cursedflames.bountifulbaubles.common.network.wormhole.SPacketWormholeRequest;
import cursedflames.bountifulbaubles.common.wormhole.WormholeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.Util;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.PacketDistributor;

public class TeleportRequest {
    public static List<TeleportRequest> requests = new ArrayList<TeleportRequest>();
    public static int REQ_EXPIRY_TIME = 400;
    public final long reqTickTime;
    public final World world;
    public final UUID origin;
    public final UUID target;
    public Status status = Status.PENDING;

    private TeleportRequest(World world, UUID origin, UUID target) {
        this.reqTickTime = world.func_82737_E();
        this.world = world;
        this.origin = origin;
        this.target = target;
    }

    public static TeleportRequest makeReq(World world, PlayerEntity origin, PlayerEntity target) {
        if (!(target instanceof ServerPlayerEntity)) {
            return null;
        }
        origin.func_145747_a((ITextComponent)new StringTextComponent("Teleport request sent to ").func_230529_a_(target.func_200200_C_()).func_240702_b_("."), Util.field_240973_b_);
        TeleportRequest req = new TeleportRequest(world, origin.func_110124_au(), target.func_110124_au());
        requests.add(req);
        PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)target), (Object)new SPacketWormholeRequest(origin.func_200200_C_().getString()));
        return req;
    }

    public static int acceptReject(PlayerEntity target, boolean accept, Collection<PlayerEntity> originPlayers) {
        int count = 0;
        long timeoutTime = target.field_70170_p.func_82737_E() - (long)REQ_EXPIRY_TIME;
        if (originPlayers == null) {
            originPlayers = target.field_70170_p.func_217369_A();
        }
        HashMap<UUID, PlayerEntity> origins = new HashMap<UUID, PlayerEntity>();
        for (PlayerEntity player : originPlayers) {
            origins.put(player.func_110124_au(), player);
        }
        Set originIDs = origins.keySet();
        for (int i = requests.size() - 1; i >= 0; --i) {
            TeleportRequest req = requests.get(i);
            if (req.reqTickTime < timeoutTime) {
                req.status = Status.TIMEOUT;
                PlayerEntity from = target.field_70170_p.func_217371_b(req.origin);
                PlayerEntity to = target.field_70170_p.func_217371_b(req.target);
                if (from != null && to != null) {
                    from.func_145747_a((ITextComponent)new StringTextComponent("Teleport request to ").func_230529_a_(to.func_200200_C_()).func_240702_b_(" has expired."), Util.field_240973_b_);
                    to.func_145747_a((ITextComponent)new StringTextComponent("Teleport request from ").func_230529_a_(from.func_200200_C_()).func_240702_b_(" has expired."), Util.field_240973_b_);
                }
                requests.remove(i);
                continue;
            }
            if (!req.target.equals(target.func_110124_au()) || !originIDs.contains(req.origin)) continue;
            PlayerEntity player = (PlayerEntity)origins.get(req.origin);
            if (!accept) {
                req.status = Status.REJECT;
                if (player != null) {
                    target.func_145747_a((ITextComponent)new StringTextComponent("Rejected teleport request from ").func_230529_a_(player.func_200200_C_()).func_240702_b_("."), Util.field_240973_b_);
                    player.func_145747_a((ITextComponent)new StringTextComponent("Teleport request to ").func_230529_a_(target.func_200200_C_()).func_240702_b_(" was rejected."), Util.field_240973_b_);
                    ++count;
                }
            } else {
                req.status = Status.ACCEPT;
                if (player != null) {
                    target.func_145747_a((ITextComponent)new StringTextComponent("Accepted teleport request from ").func_230529_a_(player.func_200200_C_()).func_240702_b_("."), Util.field_240973_b_);
                    player.func_145747_a((ITextComponent)new StringTextComponent("Teleport request to ").func_230529_a_(target.func_200200_C_()).func_240702_b_(" was accepted."), Util.field_240973_b_);
                    IFormattableTextComponent message1 = null;
                    StringTextComponent message2 = null;
                    if (player.func_184218_aH()) {
                        message1 = new StringTextComponent("Teleport failed as ").func_230529_a_(player.func_200200_C_()).func_240702_b_(" is mounted.");
                        message2 = new StringTextComponent("Teleport failed as you are mounted.");
                    } else if (WormholeUtil.consumeItem(player)) {
                        WormholeUtil.doTeleport(player, target);
                    } else {
                        message1 = new StringTextComponent("Teleport failed as ").func_230529_a_(player.func_200200_C_()).func_240702_b_(" has no wormhole potions or mirror.");
                        message2 = new StringTextComponent("Teleport failed as you have no wormhole potions or mirror.");
                    }
                    if (message1 != null) {
                        target.func_145747_a((ITextComponent)message1, Util.field_240973_b_);
                    }
                    if (message2 != null) {
                        player.func_145747_a((ITextComponent)message2, Util.field_240973_b_);
                    }
                    ++count;
                }
            }
            requests.remove(i);
        }
        return count;
    }

    public static enum Status {
        PENDING,
        ACCEPT,
        REJECT,
        TIMEOUT;

    }
}

