/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.comforts.data;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.data.LootTableProvider;
import net.minecraft.loot.LootParameterSet;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.loot.ValidationTracker;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.theillusivec4.comforts.data.ComfortsBlockLootTables;

public class ComfortsLootProvider
extends LootTableProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final DataGenerator dataGenerator;
    private final List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> lootTables = ImmutableList.of((Object)Pair.of(ComfortsBlockLootTables::new, (Object)LootParameterSets.field_216267_h));

    public ComfortsLootProvider(DataGenerator generatorIn) {
        super(generatorIn);
        this.dataGenerator = generatorIn;
    }

    private static Path getPath(Path pathIn, ResourceLocation id) {
        return pathIn.resolve("data/" + id.func_110624_b() + "/loot_tables/" + id.func_110623_a() + ".json");
    }

    public void func_200398_a(@Nonnull DirectoryCache cache) {
        Path path = this.dataGenerator.func_200391_b();
        HashMap map = Maps.newHashMap();
        this.lootTables.forEach(lootPair -> ((Consumer)((Supplier)lootPair.getFirst()).get()).accept((resourceLocation, lootTable) -> {
            if (map.put(resourceLocation, lootTable.func_216039_a((LootParameterSet)lootPair.getSecond()).func_216038_b()) != null) {
                throw new IllegalStateException("Duplicate loot table " + resourceLocation);
            }
        }));
        ValidationTracker validationtracker = new ValidationTracker(LootParameterSets.field_216266_g, resourceLocation -> null, map::get);
        this.validate(map, validationtracker);
        Multimap multimap = validationtracker.func_227527_a_();
        if (!multimap.isEmpty()) {
            multimap.forEach((problemPath, problem) -> LOGGER.warn("Found validation problem in " + problemPath + ": " + problem));
            throw new IllegalStateException("Failed to validate loot tables, see logs");
        }
        map.forEach((resourceLocation, lootTable) -> {
            Path path1 = ComfortsLootProvider.getPath(path, resourceLocation);
            try {
                IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)LootTableManager.func_215301_a((LootTable)lootTable), (Path)path1);
            }
            catch (IOException ioexception) {
                LOGGER.error("Couldn't save loot table {}", (Object)path1, (Object)ioexception);
            }
        });
    }

    @Nonnull
    public String func_200397_b() {
        return "comfortsLootTables";
    }
}

