/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.api.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcp.mobius.waila.api.ITaggableList;

public class TaggableList<TAG, VALUE>
extends ArrayList<VALUE>
implements ITaggableList<TAG, VALUE> {
    protected final Map<TAG, VALUE> tags = Maps.newHashMap();
    private final Function<TAG, VALUE> setProcessor;

    public TaggableList(@Nonnull Function<TAG, VALUE> setProcessor) {
        Preconditions.checkNotNull(setProcessor);
        this.setProcessor = setProcessor;
    }

    @Override
    public void setTag(@Nonnull TAG tag, @Nonnull VALUE value) {
        Preconditions.checkNotNull(tag);
        Preconditions.checkNotNull(value);
        VALUE old = this.tags.put(tag, value);
        if (old == null) {
            this.add(this.setProcessor.apply(tag));
        }
    }

    @Override
    public VALUE removeTag(@Nonnull TAG tag) {
        Preconditions.checkNotNull(tag);
        return this.tags.remove(tag);
    }

    @Override
    @Nullable
    public VALUE getTag(@Nonnull TAG tag) {
        Preconditions.checkNotNull(tag);
        return this.tags.get(tag);
    }

    @Override
    @Nonnull
    public Map<TAG, VALUE> getTags() {
        return this.tags;
    }

    @Override
    public void absorb(@Nonnull ITaggableList<TAG, VALUE> other) {
        this.addAll(other);
        this.tags.putAll(other.getTags());
    }
}

