/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.container;

import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.block.SharestoneBlock;
import net.blay09.mods.waystones.container.ModContainers;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.core.WarpMode;
import net.blay09.mods.waystones.core.Waystone;
import net.blay09.mods.waystones.core.WaystoneManager;
import net.blay09.mods.waystones.core.WaystoneTypes;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.DyeColor;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;

public class WaystoneSelectionContainer
extends Container {
    private final WarpMode warpMode;
    private final IWaystone fromWaystone;
    private final List<IWaystone> waystones;

    public WaystoneSelectionContainer(ContainerType<WaystoneSelectionContainer> type, WarpMode warpMode, @Nullable IWaystone fromWaystone, int windowId, List<IWaystone> waystones) {
        super(type, windowId);
        this.warpMode = warpMode;
        this.fromWaystone = fromWaystone;
        this.waystones = waystones;
    }

    public boolean func_75145_c(PlayerEntity player) {
        if (this.fromWaystone != null) {
            BlockPos pos = this.fromWaystone.getPos();
            return player.func_70092_e((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5) <= 64.0;
        }
        return true;
    }

    @Nullable
    public IWaystone getWaystoneFrom() {
        return this.fromWaystone;
    }

    public WarpMode getWarpMode() {
        return this.warpMode;
    }

    public List<IWaystone> getWaystones() {
        return this.waystones;
    }

    public static WaystoneSelectionContainer createWaystoneSelection(int windowId, PlayerEntity player, WarpMode warpMode, @Nullable IWaystone fromWaystone) {
        List<IWaystone> waystones = PlayerWaystoneManager.getWaystones(player);
        return new WaystoneSelectionContainer(ModContainers.waystoneSelection, warpMode, fromWaystone, windowId, waystones);
    }

    public static WaystoneSelectionContainer createSharestoneSelection(int windowId, IWaystone fromWaystone, BlockState state) {
        SharestoneBlock block = (SharestoneBlock)state.func_177230_c();
        ResourceLocation waystoneType = WaystoneTypes.getSharestone(block.getColor());
        List<IWaystone> waystones = WaystoneManager.get().getWaystonesByType(waystoneType).collect(Collectors.toList());
        return new WaystoneSelectionContainer(ModContainers.sharestoneSelection, WarpMode.SHARESTONE_TO_SHARESTONE, fromWaystone, windowId, waystones);
    }

    public static void writeSharestoneContainer(PacketBuffer buf, BlockPos pos, @Nullable DyeColor color) {
        ResourceLocation waystoneType = WaystoneTypes.getSharestone(color);
        List waystones = WaystoneManager.get().getWaystonesByType(waystoneType).collect(Collectors.toList());
        buf.func_179255_a(pos);
        buf.writeShort(waystones.size());
        for (IWaystone waystone : waystones) {
            Waystone.write(buf, waystone);
        }
    }
}

