/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.capability;

import java.util.function.IntSupplier;
import net.minecraftforge.energy.IEnergyStorage;

public abstract class ConfigEnergyStorage
implements IEnergyStorage {
    private final IntSupplier capacitySupplier;
    private final IntSupplier extractSupplier;
    private final IntSupplier receiveSupplier;
    private int energy;

    public ConfigEnergyStorage(IntSupplier capacitySupplier, IntSupplier extractSupplier, IntSupplier receiveSupplier) {
        this.capacitySupplier = capacitySupplier;
        this.extractSupplier = extractSupplier;
        this.receiveSupplier = receiveSupplier;
        this.energy = 0;
    }

    public ConfigEnergyStorage(IntSupplier capacitySupplier, IntSupplier transfer) {
        this(capacitySupplier, transfer, transfer);
    }

    public ConfigEnergyStorage(IntSupplier capacity) {
        this(capacity, capacity);
    }

    public int getEnergyStored() {
        this.updateEnergy();
        return this.getEnergyStoredCache();
    }

    public int getMaxEnergyStored() {
        return this.capacitySupplier.getAsInt();
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (maxReceive < 0) {
            return 0;
        }
        int energyReceived = this.evaluateEnergyReceived(maxReceive, simulate);
        if (!simulate) {
            this.setEnergy(energyReceived + this.getEnergyStored());
            this.writeEnergy();
        }
        return energyReceived;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (maxExtract < 0) {
            return 0;
        }
        int energyExtracted = this.evaluateEnergyExtracted(maxExtract, simulate);
        if (!simulate) {
            this.setEnergy(this.getEnergyStored() - energyExtracted);
            this.writeEnergy();
        }
        return energyExtracted;
    }

    public boolean canExtract() {
        return this.extractSupplier.getAsInt() > 0;
    }

    public boolean canReceive() {
        return this.receiveSupplier.getAsInt() > 0;
    }

    protected IntSupplier getExtractSupplier() {
        return this.extractSupplier;
    }

    protected IntSupplier getReceiveSupplier() {
        return this.receiveSupplier;
    }

    protected int evaluateEnergyExtracted(int maxExtract, boolean simulate) {
        return Math.min(this.getEnergyStored(), Math.min(maxExtract, this.getExtractSupplier().getAsInt()));
    }

    protected int evaluateEnergyReceived(int maxReceive, boolean simulate) {
        return Math.min(this.getMaxEnergyStored() - this.getEnergyStored(), Math.min(maxReceive, this.getReceiveSupplier().getAsInt()));
    }

    public void setEnergy(int energy) {
        this.energy = energy;
    }

    protected int getEnergyStoredCache() {
        return this.energy;
    }

    protected abstract void writeEnergy();

    protected abstract void updateEnergy();

    protected void updateMaxEnergy() {
        this.energy = Math.min(this.getMaxEnergyStored(), this.energy);
    }
}

