/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.commands;

import com.direwolf20.buildinggadgets.common.BuildingGadgets;
import com.direwolf20.buildinggadgets.common.util.lang.ITranslationProvider;
import com.direwolf20.buildinggadgets.common.util.lang.Styles;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;

final class AllowPlayerOverrideManager {
    private final Cache<UUID, Boolean> allowPlayerOverrideCache = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).removalListener(notification -> BuildingGadgets.LOG.info("Player with id {} was removed from the list of players for which '{}' is {} enabled. He/She will need to run the command again for '{}' to become active again.", notification.getKey(), (Object)logMessage, (Object)((Boolean)notification.getValue() != false ? "" : "not"), (Object)logMessage)).build();
    private final ITranslationProvider noPlayerTranslation;
    private final ITranslationProvider toggledTranslation;
    private final ITranslationProvider listTranslation;
    private final String logMessage;

    public AllowPlayerOverrideManager(ITranslationProvider noPlayerTranslation, ITranslationProvider toggledTranslation, ITranslationProvider listTranslation, String logMessage) {
        this.noPlayerTranslation = noPlayerTranslation;
        this.toggledTranslation = toggledTranslation;
        this.listTranslation = listTranslation;
        this.logMessage = logMessage;
    }

    void toggleAllowOverride(Player player) {
        this.toggleAllowOverride(player.m_142081_());
    }

    void toggleAllowOverride(UUID uuid) {
        try {
            this.allowPlayerOverrideCache.put((Object)uuid, (Object)((Boolean)this.allowPlayerOverrideCache.get((Object)uuid, () -> false) == false ? 1 : 0));
        }
        catch (ExecutionException e) {
            BuildingGadgets.LOG.warn("Failed to toggle '{}' for player {}", (Object)this.logMessage, (Object)uuid, (Object)e);
        }
    }

    boolean mayOverride(UUID uuid) {
        Boolean res = (Boolean)this.allowPlayerOverrideCache.getIfPresent((Object)uuid);
        return res != null ? res : false;
    }

    boolean mayOverride(Player player) {
        return this.mayOverride(player.m_142081_());
    }

    int executeToggle(CommandContext<CommandSourceStack> context, Player player) {
        if (player == null) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)this.noPlayerTranslation.componentTranslation(new Object[0]).m_6270_(Styles.RED));
            return 0;
        }
        this.toggleAllowOverride(player);
        ((CommandSourceStack)context.getSource()).m_81354_((Component)this.toggledTranslation.componentTranslation(player.m_5446_(), this.mayOverride(player)).m_6270_(Styles.AQUA), true);
        return 1;
    }

    int executeList(CommandContext<CommandSourceStack> context) {
        for (Map.Entry entry : this.allowPlayerOverrideCache.asMap().entrySet()) {
            TranslatableComponent component = this.listTranslation.componentTranslation(entry.getKey(), entry.getValue());
            component = (TranslatableComponent)((Boolean)entry.getValue() != false ? component.m_6270_(Styles.BLUE) : component.m_6270_(Styles.DK_GREEN));
            ((CommandSourceStack)context.getSource()).m_81354_((Component)component, true);
        }
        return 1;
    }
}

