/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.items;

import com.direwolf20.buildinggadgets.client.renders.BaseRenderer;
import com.direwolf20.buildinggadgets.client.renders.DestructionRender;
import com.direwolf20.buildinggadgets.client.screen.GuiMod;
import com.direwolf20.buildinggadgets.common.blocks.EffectBlock;
import com.direwolf20.buildinggadgets.common.blocks.OurBlocks;
import com.direwolf20.buildinggadgets.common.config.Config;
import com.direwolf20.buildinggadgets.common.items.AbstractGadget;
import com.direwolf20.buildinggadgets.common.items.OurItems;
import com.direwolf20.buildinggadgets.common.tainted.building.BlockData;
import com.direwolf20.buildinggadgets.common.tainted.building.Region;
import com.direwolf20.buildinggadgets.common.tainted.building.tilesupport.TileSupport;
import com.direwolf20.buildinggadgets.common.tainted.inventory.materials.objects.IUniqueObject;
import com.direwolf20.buildinggadgets.common.tainted.save.Undo;
import com.direwolf20.buildinggadgets.common.tileentities.ConstructionBlockTileEntity;
import com.direwolf20.buildinggadgets.common.util.GadgetUtils;
import com.direwolf20.buildinggadgets.common.util.helpers.VectorHelper;
import com.direwolf20.buildinggadgets.common.util.lang.Styles;
import com.direwolf20.buildinggadgets.common.util.lang.TooltipTranslation;
import com.direwolf20.buildinggadgets.common.util.ref.Reference;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multiset;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;

public class GadgetDestruction
extends AbstractGadget {
    public GadgetDestruction() {
        super(OurItems.nonStackableItemProperties(), () -> ((ForgeConfigSpec.IntValue)Config.GADGETS.GADGET_DESTRUCTION.undoSize).get(), "buildinggadgets_undo_destruction", Reference.BlockReference.TagReference.WHITELIST_DESTRUCTION, Reference.BlockReference.TagReference.BLACKLIST_DESTRUCTION);
    }

    @Override
    public int getEnergyMax() {
        return (Integer)Config.GADGETS.GADGET_DESTRUCTION.maxEnergy.get();
    }

    @Override
    public int getEnergyCost(ItemStack tool) {
        return (Integer)Config.GADGETS.GADGET_DESTRUCTION.energyCost.get() * this.getCostMultiplier(tool);
    }

    @Override
    protected Supplier<BaseRenderer> createRenderFactory() {
        return DestructionRender::new;
    }

    private int getCostMultiplier(ItemStack tool) {
        return (int)(!GadgetDestruction.getFuzzy(tool) ? (Double)Config.GADGETS.GADGET_DESTRUCTION.nonFuzzyMultiplier.get() : 1.0);
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, world, tooltip, flag);
        this.addEnergyInformation(tooltip, stack);
        tooltip.add((Component)TooltipTranslation.GADGET_DESTROYWARNING.componentTranslation(new Object[0]).m_6270_(Styles.RED));
        tooltip.add((Component)TooltipTranslation.GADGET_DESTROYSHOWOVERLAY.componentTranslation(String.valueOf(GadgetDestruction.getOverlay(stack))).m_6270_(Styles.AQUA));
        tooltip.add((Component)TooltipTranslation.GADGET_BUILDING_PLACE_ATOP.componentTranslation(String.valueOf(GadgetDestruction.getConnectedArea(stack))).m_6270_(Styles.YELLOW));
        if (((Boolean)Config.GADGETS.GADGET_DESTRUCTION.nonFuzzyEnabled.get()).booleanValue()) {
            tooltip.add((Component)TooltipTranslation.GADGET_FUZZY.componentTranslation(String.valueOf(GadgetDestruction.getFuzzy(stack))).m_6270_(Styles.GOLD));
        }
        GadgetDestruction.addInformationRayTraceFluid(tooltip, stack);
    }

    public static void setAnchor(ItemStack stack, BlockPos pos) {
        GadgetUtils.writePOSToNBT(stack, pos, "anchor");
    }

    public static void setAnchorSide(ItemStack stack, Direction side) {
        CompoundTag tag = stack.m_41784_();
        if (side == null) {
            tag.m_128473_("anchor_side");
        } else {
            tag.m_128359_("anchor_side", side.m_122433_());
        }
    }

    public static Direction getAnchorSide(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        String facing = tag.m_128461_("anchor_side");
        if (facing.isEmpty()) {
            return null;
        }
        return Direction.m_122402_((String)facing);
    }

    public static void setToolValue(ItemStack stack, int value, String valueName) {
        stack.m_41784_().m_128405_(valueName, value);
    }

    public static int getToolValue(ItemStack stack, String valueName) {
        return stack.m_41784_().m_128451_(valueName);
    }

    public static boolean getOverlay(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_("overlay")) {
            return tag.m_128471_("overlay");
        }
        tag.m_128379_("overlay", true);
        tag.m_128379_("fuzzy", true);
        return true;
    }

    public static void setOverlay(ItemStack stack, boolean showOverlay) {
        stack.m_41784_().m_128379_("overlay", showOverlay);
    }

    public static void switchOverlay(Player player, ItemStack stack) {
        boolean newOverlay = !GadgetDestruction.getOverlay(stack);
        GadgetDestruction.setOverlay(stack, newOverlay);
        player.m_5661_((Component)TooltipTranslation.GADGET_DESTROYSHOWOVERLAY.componentTranslation(newOverlay).m_6270_(Styles.AQUA), true);
    }

    public static boolean getIsFluidOnly(ItemStack stack) {
        return stack.m_41784_().m_128471_("fluid");
    }

    public static void toggleFluidMode(ItemStack stack) {
        stack.m_41784_().m_128379_("fluid", !GadgetDestruction.getIsFluidOnly(stack));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        player.m_6672_(hand);
        if (!world.f_46443_) {
            if (!player.m_6144_()) {
                BlockPos anchorPos = this.getAnchor(stack);
                Direction anchorSide = GadgetDestruction.getAnchorSide(stack);
                if (anchorPos != null && anchorSide != null) {
                    this.clearArea(world, anchorPos, anchorSide, (ServerPlayer)player, stack);
                    this.onAnchorRemoved(stack, player);
                    return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
                }
                BlockHitResult lookingAt = VectorHelper.getLookingAt(player, stack);
                if (!world.m_46859_(lookingAt.m_82425_())) {
                    this.clearArea(world, lookingAt.m_82425_(), lookingAt.m_82434_(), (ServerPlayer)player, stack);
                    this.onAnchorRemoved(stack, player);
                    return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
                }
                return new InteractionResultHolder(InteractionResult.FAIL, (Object)stack);
            }
        } else if (player.m_6144_()) {
            GuiMod.DESTRUCTION.openScreen(player);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    @Override
    protected void onAnchorSet(ItemStack stack, Player player, BlockHitResult lookingAt) {
        super.onAnchorSet(stack, player, lookingAt);
        GadgetDestruction.setAnchorSide(stack, lookingAt.m_82434_());
    }

    @Override
    protected void onAnchorRemoved(ItemStack stack, Player player) {
        super.onAnchorRemoved(stack, player);
        GadgetDestruction.setAnchorSide(stack, null);
    }

    public static List<BlockPos> getArea(Level world, BlockPos pos, Direction incomingSide, Player player, ItemStack stack) {
        ItemStack tool = GadgetDestruction.getGadget(player);
        int depth = GadgetDestruction.getToolValue(stack, "depth");
        if (tool.m_41619_() || depth == 0 || !player.m_36326_()) {
            return new ArrayList<BlockPos>();
        }
        boolean vertical = incomingSide.m_122434_().m_122478_();
        Direction up = vertical ? player.m_6350_() : Direction.UP;
        Direction down = up.m_122424_();
        Direction right = vertical ? up.m_122427_() : incomingSide.m_122428_();
        Direction left = right.m_122424_();
        BlockPos first = pos.m_5484_(left, GadgetDestruction.getToolValue(stack, "left")).m_5484_(up, GadgetDestruction.getToolValue(stack, "up"));
        BlockPos second = pos.m_5484_(right, GadgetDestruction.getToolValue(stack, "right")).m_5484_(down, GadgetDestruction.getToolValue(stack, "down")).m_5484_(incomingSide.m_122424_(), depth - 1);
        boolean isFluidOnly = GadgetDestruction.getIsFluidOnly(stack);
        return new Region((Vec3i)first, (Vec3i)second).stream().filter(e -> isFluidOnly ? GadgetDestruction.isFluidBlock(world, e) : GadgetDestruction.isValidBlock(world, e, player, world.m_8055_(e))).sorted(Comparator.comparing(arg_0 -> ((BlockPos)player.m_142538_()).m_123331_(arg_0))).collect(Collectors.toList());
    }

    public static boolean isFluidBlock(Level world, BlockPos pos) {
        if (world.m_6425_(pos).m_76178_()) {
            return false;
        }
        return ForgeRegistries.FLUIDS.containsKey(world.m_8055_(pos).m_60734_().getRegistryName());
    }

    public static boolean isValidBlock(Level world, BlockPos voidPos, Player player, BlockState currentBlock) {
        if (world.m_46859_(voidPos) || currentBlock.equals(((Block)OurBlocks.EFFECT_BLOCK.get()).m_49966_()) || currentBlock.m_60800_((BlockGetter)world, voidPos) < 0.0f || !world.m_7966_(player, voidPos)) {
            return false;
        }
        BlockEntity te = world.m_7702_(voidPos);
        if (te != null && !(te instanceof ConstructionBlockTileEntity)) {
            return false;
        }
        if (!world.f_46443_) {
            BlockSnapshot blockSnapshot = BlockSnapshot.create((ResourceKey)world.m_46472_(), (LevelAccessor)world, (BlockPos)voidPos);
            if (ForgeEventFactory.onBlockPlace((Entity)player, (BlockSnapshot)blockSnapshot, (Direction)Direction.UP)) {
                return false;
            }
            BlockEvent.BreakEvent e = new BlockEvent.BreakEvent(world, voidPos, currentBlock, player);
            return !MinecraftForge.EVENT_BUS.post((Event)e);
        }
        return true;
    }

    public void clearArea(Level world, BlockPos pos, Direction side, ServerPlayer player, ItemStack stack) {
        List<BlockPos> positions = GadgetDestruction.getArea(world, pos, side, (Player)player, stack);
        Undo.Builder builder = Undo.builder();
        for (BlockPos clearPos : positions) {
            BlockState state = world.m_8055_(clearPos);
            BlockEntity te = world.m_7702_(clearPos);
            if (!this.isAllowedBlock(state) || te != null && (state.m_60734_() != OurBlocks.CONSTRUCTION_BLOCK.get() || !(te instanceof ConstructionBlockTileEntity))) continue;
            this.destroyBlock(world, clearPos, player, builder);
        }
        this.pushUndo(stack, builder.build(world));
    }

    private boolean destroyBlock(Level world, BlockPos voidPos, ServerPlayer player, Undo.Builder builder) {
        if (world.m_46859_(voidPos)) {
            return false;
        }
        ItemStack tool = GadgetDestruction.getGadget((Player)player);
        if (tool.m_41619_()) {
            return false;
        }
        if (!this.canUse(tool, (Player)player)) {
            return false;
        }
        this.applyDamage(tool, player);
        builder.record((BlockGetter)world, voidPos, BlockData.AIR, (Multiset<IUniqueObject<?>>)ImmutableMultiset.of(), (Multiset<IUniqueObject<?>>)ImmutableMultiset.of());
        EffectBlock.spawnEffectBlock((LevelAccessor)world, voidPos, TileSupport.createBlockData((BlockGetter)world, voidPos), EffectBlock.Mode.REMOVE, false);
        return true;
    }

    public static ItemStack getGadget(Player player) {
        ItemStack stack = AbstractGadget.getGadget(player);
        if (!(stack.m_41720_() instanceof GadgetDestruction)) {
            return ItemStack.f_41583_;
        }
        return stack;
    }
}

