/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.util.helpers;

import com.google.common.collect.Multiset;
import java.util.AbstractList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.StreamSupport;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Tuple;

public class NBTHelper {
    public static <T> ListTag writeIterable(Iterable<T> iterable, Function<? super T, ? extends Tag> serializer) {
        return StreamSupport.stream(iterable.spliterator(), false).map(serializer).collect(NBTHelper.toListNBT());
    }

    public static <K, V> ListTag serializeMap(Map<K, V> map, Function<? super K, ? extends Tag> keySerializer, Function<? super V, ? extends Tag> valueSerializer) {
        ListTag list = new ListTag();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            CompoundTag compound = new CompoundTag();
            compound.m_128365_("key", keySerializer.apply(entry.getKey()));
            compound.m_128365_("val", valueSerializer.apply(entry.getValue()));
            list.add((Object)compound);
        }
        return list;
    }

    public static <V> ListTag serializeUUIDMap(Map<UUID, V> map, Function<? super V, ? extends Tag> valueSerializer) {
        ListTag list = new ListTag();
        for (Map.Entry<UUID, V> entry : map.entrySet()) {
            CompoundTag compound = new CompoundTag();
            compound.m_128362_("key", entry.getKey());
            compound.m_128365_("val", valueSerializer.apply(entry.getValue()));
            list.add((Object)compound);
        }
        return list;
    }

    public static <K, V> Map<K, V> deserializeMap(ListTag list, Map<K, V> toAppendTo, Function<Tag, ? extends K> keyDeserializer, Function<Tag, ? extends V> valueDeserializer) {
        for (Tag nbt : list) {
            if (!(nbt instanceof CompoundTag)) continue;
            CompoundTag compound = (CompoundTag)nbt;
            toAppendTo.put(keyDeserializer.apply(compound.m_128423_("key")), valueDeserializer.apply(compound.m_128423_("val")));
        }
        return toAppendTo;
    }

    public static <V> Map<UUID, V> deserializeUUIDMap(ListTag list, Map<UUID, V> toAppendTo, Function<Tag, ? extends V> valueDeserializer) {
        for (Tag nbt : list) {
            if (!(nbt instanceof CompoundTag)) continue;
            CompoundTag compound = (CompoundTag)nbt;
            toAppendTo.put(compound.m_128342_("key"), valueDeserializer.apply(compound.m_128423_("val")));
        }
        return toAppendTo;
    }

    public static <T, C extends Collection<T>> C deserializeCollection(ListTag list, C toAppendTo, Function<Tag, ? extends T> elementDeserializer) {
        for (Tag nbt : list) {
            toAppendTo.add(elementDeserializer.apply(nbt));
        }
        return toAppendTo;
    }

    public static <T> Multiset<T> deserializeMultisetEntries(ListTag list, Multiset<T> toAppendTo, Function<Tag, Tuple<? extends T, Integer>> entryDeserializer) {
        list.stream().map(entryDeserializer).forEach(p -> toAppendTo.add(p.m_14418_(), ((Integer)p.m_14419_()).intValue()));
        return toAppendTo;
    }

    public static <T extends Tag> Collector<T, ListTag, ListTag> toListNBT() {
        return new Collector<T, ListTag, ListTag>(){

            @Override
            public Supplier<ListTag> supplier() {
                return ListTag::new;
            }

            @Override
            public BiConsumer<ListTag, T> accumulator() {
                return AbstractList::add;
            }

            @Override
            public BinaryOperator<ListTag> combiner() {
                return (l1, l2) -> {
                    l1.addAll((Collection)l2);
                    return l1;
                };
            }

            @Override
            public Function<ListTag, ListTag> finisher() {
                return Function.identity();
            }

            @Override
            public Set<Collector.Characteristics> characteristics() {
                return EnumSet.of(Collector.Characteristics.IDENTITY_FINISH, Collector.Characteristics.UNORDERED);
            }
        };
    }
}

